/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systests.cdi.base;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.systests.cdi.base.BookStoreService;
import org.apache.cxf.systests.cdi.base.bindings.Logged;

@Path(value="/bookstore/request")
@RequestScoped
@Logged
public class RequestScopedBookStore {
    private BookStoreService service;
    private UriInfo uriInfo;

    public RequestScopedBookStore() {
    }

    @Inject
    public RequestScopedBookStore(BookStoreService service, UriInfo uriInfo) {
        this.service = service;
        this.uriInfo = uriInfo;
    }

    @GET
    @Path(value="/books")
    @NotNull
    @Valid
    @Produces(value={"application/json"})
    public Response getBooks() {
        return Response.ok().entity(this.service.all()).contentLocation(this.uriInfo.getAbsolutePath()).build();
    }
}

