/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.kerberos.common;

import java.io.File;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.ws.security.trust.STSClient;
import org.example.contract.doubleit.DoubleItPortType;

public final class SecurityTestUtil {
    private static final boolean UNRESTRICTED_POLICIES_INSTALLED;

    private SecurityTestUtil() {
    }

    public static void cleanup() {
        File[] tmpFiles;
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir != null && (tmpFiles = new File(tmpDir).listFiles()) != null) {
            for (File tmpFile : tmpFiles) {
                if (!tmpFile.exists() || !tmpFile.getName().startsWith("ws-security.nonce.cache") && !tmpFile.getName().startsWith("wss4j-nonce-cache") && !tmpFile.getName().startsWith("ws-security.timestamp.cache") && !tmpFile.getName().startsWith("wss4j-timestamp-cache")) continue;
                tmpFile.delete();
            }
        }
    }

    public static boolean checkUnrestrictedPoliciesInstalled() {
        return UNRESTRICTED_POLICIES_INSTALLED;
    }

    public static void enableStreaming(DoubleItPortType port) {
        ((BindingProvider)port).getRequestContext().put("ws-security.enable.streaming", "true");
        ((BindingProvider)port).getResponseContext().put("ws-security.enable.streaming", "true");
    }

    public static void updateSTSPort(BindingProvider p, String port) {
        String location;
        STSClient stsClient = (STSClient)p.getRequestContext().get("ws-security.sts.client");
        if (stsClient != null) {
            location = stsClient.getWsdlLocation();
            if (location != null && location.contains("8080")) {
                stsClient.setWsdlLocation(location.replace("8080", port));
            } else if (location != null && location.contains("8443")) {
                stsClient.setWsdlLocation(location.replace("8443", port));
            }
        }
        if ((stsClient = (STSClient)p.getRequestContext().get("ws-security.sts.client.sct")) != null) {
            location = stsClient.getWsdlLocation();
            if (location.contains("8080")) {
                stsClient.setWsdlLocation(location.replace("8080", port));
            } else if (location.contains("8443")) {
                stsClient.setWsdlLocation(location.replace("8443", port));
            }
        }
    }

    static {
        boolean ok = false;
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            ok = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        UNRESTRICTED_POLICIES_INSTALLED = ok;
    }
}

