/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.kerberos.jaxrs.kerberos;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.cxf.annotations.GZIP;
import org.apache.cxf.systest.kerberos.jaxrs.kerberos.Book;
import org.apache.cxf.systest.kerberos.jaxrs.kerberos.BookNotFoundFault;

@Path(value="/bookstore")
@GZIP(threshold=1)
public interface BookStore {
    @GET
    @Path(value="/")
    public Book getBookRoot();

    @Path(value="/default")
    @Produces(value={"application/xml"})
    public Book getDefaultBook();

    @GET
    @Path(value="/books/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getBook(@PathParam(value="bookId") String var1) throws BookNotFoundFault;

    @GET
    @Path(value="/books/query/default")
    @Produces(value={"application/xml"})
    public Book getBook(@QueryParam(value="bookId") long var1) throws BookNotFoundFault;

    @GET
    @Path(value="/the books/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getBookWithSpace(@PathParam(value="bookId") String var1) throws BookNotFoundFault;

    @PathParam(value="bookId")
    public void setBookId(String var1);

    public void setDefaultNameAndId(String var1, long var2);

    @GET
    @Path(value="/books/{bookId}/")
    @Produces(value={"application/json;qs=0.9"})
    public Book getBookAsJSON() throws BookNotFoundFault;

    public static class BookNotReturnedException
    extends RuntimeException {
        private static final long serialVersionUID = 4935423670510083220L;

        public BookNotReturnedException(String errorMessage) {
            super(errorMessage);
        }
    }
}

