/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.kerberos.jaxrs.kerberos;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.systest.kerberos.jaxrs.kerberos.Book;
import org.apache.cxf.systest.kerberos.jaxrs.kerberos.BookNotFoundDetails;
import org.apache.cxf.systest.kerberos.jaxrs.kerberos.BookNotFoundFault;
import org.apache.cxf.systest.kerberos.jaxrs.kerberos.BookStore;

public class BookStoreImpl
implements BookStore {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private long bookId = 123L;
    private String defaultName;
    private long defaultId;
    private String currentBookId;

    public BookStoreImpl() {
        this.init();
    }

    public BookStoreImpl(UriInfo ui) {
        this.init();
    }

    @Override
    public Book getBookRoot() {
        return new Book("root", 124L);
    }

    @Override
    public Book getDefaultBook() {
        return new Book(this.defaultName, this.defaultId);
    }

    @Override
    public Book getBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @Override
    public Book getBook(@QueryParam(value="bookId") long id) throws BookNotFoundFault {
        return this.books.get(id + 123L);
    }

    @Override
    public Book getBookWithSpace(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @Override
    public void setBookId(String id) {
        this.currentBookId = id;
    }

    @Override
    public void setDefaultNameAndId(String name, long id) {
        this.defaultName = name;
        this.defaultId = id;
    }

    @Override
    public Book getBookAsJSON() throws BookNotFoundFault {
        return this.doGetBook(this.currentBookId);
    }

    private Book doGetBook(String id) throws BookNotFoundFault {
        Book book = this.books.get(Long.parseLong(id));
        if (book != null) {
            return book;
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(Long.parseLong(id));
        throw new BookNotFoundFault(details);
    }

    public final String init() {
        this.books.clear();
        this.bookId = 123L;
        Book book = new Book();
        book.setId(this.bookId);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
        return "OK";
    }
}

