/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.kerberos.ldap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimTypes;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.LdapClaimsHandler;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.wss4j.common.principal.CustomTokenPrincipal;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.Assert;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="LDAPClaimsTest-class", enableAccessControl=false, allowAnonAccess=false, enableChangeLog=true, partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifFiles(value={"ldap.ldif"})
public class LDAPClaimsTest
extends AbstractLdapTestUnit {
    private static Properties props;
    private static boolean portUpdated;
    private ClassPathXmlApplicationContext appContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void startServers() throws Exception {
        props = new Properties();
        InputStream is = null;
        try {
            is = LDAPClaimsTest.class.getResourceAsStream("/ldap.properties");
            props.load(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Before
    public void updatePort() throws Exception {
        if (!portUpdated) {
            String basedir = System.getProperty("basedir");
            if (basedir == null) {
                basedir = new File(".").getCanonicalPath();
            }
            File f = new File(basedir + "/src/test/resources/ldap.xml");
            FileInputStream inputStream = new FileInputStream(f);
            String content = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            inputStream.close();
            content = content.replaceAll("portno", "" + AbstractLdapTestUnit.getLdapServer().getPort());
            File f2 = new File(basedir + "/target/test-classes/ldapport.xml");
            FileOutputStream outputStream = new FileOutputStream(f2);
            IOUtils.write((String)content, (OutputStream)outputStream, (String)"UTF-8");
            outputStream.close();
            portUpdated = true;
        }
        this.appContext = new ClassPathXmlApplicationContext("ldapport.xml");
    }

    @Test
    public void testRetrieveClaims() throws Exception {
        LdapClaimsHandler claimsHandler = (LdapClaimsHandler)this.appContext.getBean("testClaimsHandler");
        String user = props.getProperty("claimUser");
        Assert.notNull((Object)user, (String)"Property 'claimUser' not configured");
        ClaimCollection requestedClaims = this.createRequestClaimCollection();
        ArrayList<URI> expectedClaims = new ArrayList<URI>();
        expectedClaims.add(ClaimTypes.FIRSTNAME);
        expectedClaims.add(ClaimTypes.LASTNAME);
        expectedClaims.add(ClaimTypes.EMAILADDRESS);
        ClaimsParameters params = new ClaimsParameters();
        params.setPrincipal((Principal)new CustomTokenPrincipal(user));
        ProcessedClaimCollection retrievedClaims = claimsHandler.retrieveClaimValues(requestedClaims, params);
        Assert.isTrue((retrievedClaims.size() == expectedClaims.size() ? 1 : 0) != 0, (String)("Retrieved number of claims [" + retrievedClaims.size() + "] doesn't match with expected [" + expectedClaims.size() + "]"));
        for (ProcessedClaim c : retrievedClaims) {
            if (expectedClaims.contains(c.getClaimType())) {
                expectedClaims.remove(c.getClaimType());
                continue;
            }
            Assert.isTrue((boolean)false, (String)("Claim '" + c.getClaimType() + "' not requested"));
        }
    }

    @Test(expected=STSException.class)
    public void testRetrieveClaimsWithUnsupportedMandatoryClaimType() throws Exception {
        LdapClaimsHandler claimsHandler = (LdapClaimsHandler)this.appContext.getBean("testClaimsHandler");
        String user = props.getProperty("claimUser");
        Assert.notNull((Object)user, (String)"Property 'claimUser' not configured");
        ClaimCollection requestedClaims = this.createRequestClaimCollection();
        Claim claim = new Claim();
        claim.setClaimType(ClaimTypes.GENDER);
        claim.setOptional(false);
        requestedClaims.add((Object)claim);
        ClaimsParameters params = new ClaimsParameters();
        params.setPrincipal((Principal)new CustomTokenPrincipal(user));
        ProcessedClaimCollection processedClaim = claimsHandler.retrieveClaimValues(requestedClaims, params);
        for (Claim requestedClaim : requestedClaims) {
            URI claimType = requestedClaim.getClaimType();
            boolean found = false;
            if (requestedClaim.isOptional()) continue;
            for (ProcessedClaim c : processedClaim) {
                if (!c.getClaimType().equals(claimType)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new STSException("Mandatory claim '" + claim.getClaimType() + "' not found");
        }
    }

    @Test
    public void testRetrieveClaimsWithUnsupportedOptionalClaimType() throws Exception {
        LdapClaimsHandler claimsHandler = (LdapClaimsHandler)this.appContext.getBean("testClaimsHandler");
        String user = props.getProperty("claimUser");
        Assert.notNull((Object)user, (String)"Property 'claimUser' not configured");
        ClaimCollection requestedClaims = this.createRequestClaimCollection();
        Claim claim = new Claim();
        claim.setClaimType(ClaimTypes.GENDER);
        claim.setOptional(true);
        requestedClaims.add((Object)claim);
        ArrayList<URI> expectedClaims = new ArrayList<URI>();
        expectedClaims.add(ClaimTypes.FIRSTNAME);
        expectedClaims.add(ClaimTypes.LASTNAME);
        expectedClaims.add(ClaimTypes.EMAILADDRESS);
        ClaimsParameters params = new ClaimsParameters();
        params.setPrincipal((Principal)new CustomTokenPrincipal(user));
        ProcessedClaimCollection retrievedClaims = claimsHandler.retrieveClaimValues(requestedClaims, params);
        Assert.isTrue((retrievedClaims.size() == expectedClaims.size() ? 1 : 0) != 0, (String)("Retrieved number of claims [" + retrievedClaims.size() + "] doesn't match with expected [" + expectedClaims.size() + "]"));
        for (ProcessedClaim c : retrievedClaims) {
            if (expectedClaims.contains(c.getClaimType())) {
                expectedClaims.remove(c.getClaimType());
                continue;
            }
            Assert.isTrue((boolean)false, (String)("Claim '" + c.getClaimType() + "' not requested"));
        }
    }

    @Test
    public void testSupportedClaims() throws Exception {
        Map mapping = CastUtils.cast((Map)((Map)this.appContext.getBean("claimsToLdapAttributeMapping")));
        LdapClaimsHandler cHandler = new LdapClaimsHandler();
        cHandler.setClaimsLdapAttributeMapping(mapping);
        List supportedClaims = cHandler.getSupportedClaimTypes();
        Assert.isTrue((mapping.size() == supportedClaims.size() ? 1 : 0) != 0, (String)"Supported claims and claims/ldap attribute mapping size different");
        for (String claim : mapping.keySet()) {
            Assert.isTrue((boolean)supportedClaims.contains(new URI(claim)), (String)("Claim '" + claim + "' not listed in supported list"));
        }
    }

    private ClaimCollection createRequestClaimCollection() {
        ClaimCollection claims = new ClaimCollection();
        Claim claim = new Claim();
        claim.setClaimType(ClaimTypes.FIRSTNAME);
        claim.setOptional(true);
        claims.add((Object)claim);
        claim = new Claim();
        claim.setClaimType(ClaimTypes.LASTNAME);
        claim.setOptional(true);
        claims.add((Object)claim);
        claim = new Claim();
        claim.setClaimType(ClaimTypes.EMAILADDRESS);
        claim.setOptional(true);
        claims.add((Object)claim);
        return claims;
    }
}

