/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.kerberos.wssec.kerberos;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.kerberos.common.SecurityTestUtil;
import org.apache.cxf.systest.kerberos.wssec.kerberos.Server;
import org.apache.cxf.systest.kerberos.wssec.kerberos.StaxServer;
import org.apache.cxf.systest.kerberos.wssec.sts.STSServer;
import org.apache.cxf.systest.kerberos.wssec.sts.StaxSTSServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.TestUtil;
import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.wss4j.dom.WSSConfig;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="AbstractKerberosTest-class", enableAccessControl=false, allowAnonAccess=false, enableChangeLog=true, partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})}, additionalInterceptors={KeyDerivationInterceptor.class})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@CreateKdcServer(transports={@CreateTransport(protocol="UDP", address="127.0.0.1")}, primaryRealm="service.ws.apache.org", kdcPrincipal="krbtgt/service.ws.apache.org@service.ws.apache.org")
@ApplyLdifFiles(value={"kerberos.ldif"})
public class KerberosTokenTest
extends AbstractLdapTestUnit {
    static final String PORT = TestUtil.getPortNumber(Server.class);
    static final String STAX_PORT = TestUtil.getPortNumber(StaxServer.class);
    static final String PORT2 = TestUtil.getPortNumber(Server.class, (int)2);
    static final String STAX_PORT2 = TestUtil.getPortNumber(StaxServer.class, (int)2);
    static final String PORT3 = TestUtil.getPortNumber(Server.class, (int)3);
    static final String STSPORT = TestUtil.getPortNumber(STSServer.class);
    static final String STAX_STSPORT = TestUtil.getPortNumber(StaxSTSServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    private static boolean unrestrictedPoliciesInstalled = SecurityTestUtil.checkUnrestrictedPoliciesInstalled();
    private static boolean runTests;
    private static boolean portUpdated;

    @Before
    public void updatePort() throws Exception {
        if (!portUpdated) {
            String basedir = System.getProperty("basedir");
            if (basedir == null) {
                basedir = new File(".").getCanonicalPath();
            }
            File f = new File(basedir + "/src/test/resources/krb5.conf");
            FileInputStream inputStream = new FileInputStream(f);
            String content = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            inputStream.close();
            content = content.replaceAll("port", "" + AbstractLdapTestUnit.getKdcServer().getTransports()[0].getPort());
            File f2 = new File(basedir + "/target/test-classes/wssec.kerberos.krb5.conf");
            FileOutputStream outputStream = new FileOutputStream(f2);
            IOUtils.write((String)content, (OutputStream)outputStream, (String)"UTF-8");
            outputStream.close();
            System.setProperty("java.security.krb5.conf", f2.getPath());
            portUpdated = true;
        }
    }

    @BeforeClass
    public static void startServers() throws Exception {
        WSSConfig.init();
        if (!"IBM Corporation".equals(System.getProperty("java.vendor"))) {
            runTests = true;
            String basedir = System.getProperty("basedir");
            basedir = basedir == null ? new File(".").getCanonicalPath() : basedir + "/..";
            System.setProperty("java.security.auth.login.config", basedir + "/kerberos/src/test/resources/kerberos.jaas");
        }
        Assert.assertTrue((String)"Server failed to launch", (boolean)AbstractBusClientServerTestBase.launchServer(Server.class, (boolean)true));
        Assert.assertTrue((String)"Server failed to launch", (boolean)AbstractBusClientServerTestBase.launchServer(StaxServer.class, (boolean)true));
        Assert.assertTrue((String)"Server failed to launch", (boolean)AbstractBusClientServerTestBase.launchServer(STSServer.class, (boolean)true));
        Assert.assertTrue((String)"Server failed to launch", (boolean)AbstractBusClientServerTestBase.launchServer(StaxSTSServer.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        AbstractBusClientServerTestBase.stopAllServers();
    }

    @Test
    public void testKerberosOverTransport() throws Exception {
        if (!runTests) {
            return;
        }
        String portName = "DoubleItKerberosTransportPort";
        this.runKerberosTest(portName, false, PORT2);
        this.runKerberosTest(portName, false, STAX_PORT2);
        this.runKerberosTest(portName, true, PORT2);
        this.runKerberosTest(portName, true, STAX_PORT2);
    }

    @Test
    public void testKerberosOverTransportDifferentConfiguration() throws Exception {
        if (!runTests) {
            return;
        }
        String portName = "DoubleItKerberosTransportPort2";
        this.runKerberosTest(portName, false, PORT2);
        this.runKerberosTest(portName, false, STAX_PORT2);
        this.runKerberosTest(portName, true, PORT2);
        this.runKerberosTest(portName, true, STAX_PORT2);
    }

    @Test
    public void testKerberosOverSymmetric() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosSymmetricPort";
        this.runKerberosTest(portName, false, PORT);
        this.runKerberosTest(portName, false, STAX_PORT);
        this.runKerberosTest(portName, true, PORT);
        this.runKerberosTest(portName, true, STAX_PORT);
    }

    @Test
    public void testKerberosOverSymmetricSupporting() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosSymmetricSupportingPort";
        this.runKerberosTest(portName, false, PORT);
        this.runKerberosTest(portName, false, STAX_PORT);
        this.runKerberosTest(portName, true, PORT);
        this.runKerberosTest(portName, true, STAX_PORT);
    }

    @Test
    public void testKerberosSupporting() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosSupportingPort";
        this.runKerberosTest(portName, false, PORT);
        this.runKerberosTest(portName, false, STAX_PORT);
        this.runKerberosTest(portName, true, PORT);
        this.runKerberosTest(portName, true, STAX_PORT);
    }

    @Test
    public void testKerberosOverAsymmetric() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosAsymmetricPort";
        this.runKerberosTest(portName, false, PORT);
        this.runKerberosTest(portName, false, STAX_PORT);
        this.runKerberosTest(portName, true, PORT);
        this.runKerberosTest(portName, true, STAX_PORT);
    }

    @Test
    public void testKerberosOverTransportEndorsing() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosTransportEndorsingPort";
        this.runKerberosTest(portName, false, PORT2);
        this.runKerberosTest(portName, false, STAX_PORT2);
        this.runKerberosTest(portName, true, PORT2);
        this.runKerberosTest(portName, true, STAX_PORT2);
    }

    @Test
    public void testKerberosOverAsymmetricEndorsing() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosAsymmetricEndorsingPort";
        this.runKerberosTest(portName, false, PORT);
        this.runKerberosTest(portName, false, STAX_PORT);
    }

    @Test
    public void testKerberosOverSymmetricProtection() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosSymmetricProtectionPort";
        this.runKerberosTest(portName, false, PORT);
        this.runKerberosTest(portName, false, STAX_PORT);
        this.runKerberosTest(portName, true, PORT);
        this.runKerberosTest(portName, true, STAX_PORT);
    }

    @Test
    public void testKerberosOverSymmetricDerivedProtection() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosSymmetricDerivedProtectionPort";
        this.runKerberosTest(portName, false, PORT);
    }

    @Test
    public void testKerberosOverAsymmetricSignedEndorsing() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosAsymmetricSignedEndorsingPort";
        this.runKerberosTest(portName, false, PORT);
        this.runKerberosTest(portName, false, STAX_PORT);
    }

    @Test
    public void testKerberosOverAsymmetricSignedEncrypted() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosAsymmetricSignedEncryptedPort";
        this.runKerberosTest(portName, false, PORT);
        this.runKerberosTest(portName, false, STAX_PORT);
        this.runKerberosTest(portName, true, PORT);
        this.runKerberosTest(portName, true, STAX_PORT);
    }

    @Test
    public void testKerberosOverSymmetricEndorsingEncrypted() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosSymmetricEndorsingEncryptedPort";
        this.runKerberosTest(portName, false, PORT);
        this.runKerberosTest(portName, false, STAX_PORT);
    }

    @Test
    public void testKerberosOverSymmetricSignedEndorsingEncrypted() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosSymmetricSignedEndorsingEncryptedPort";
        this.runKerberosTest(portName, false, PORT);
        this.runKerberosTest(portName, false, STAX_PORT);
    }

    @Test
    public void testKerberosOverSymmetricSecureConversation() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItKerberosSymmetricSecureConversationPort";
        this.runKerberosTest(portName, false, PORT);
    }

    @Test
    public void testWSTrustKerberosToken() throws Exception {
        if (!runTests || !unrestrictedPoliciesInstalled) {
            return;
        }
        String portName = "DoubleItTransportSAML2Port";
        this.runKerberosSTSTest(portName, false, PORT3, STSPORT);
        this.runKerberosSTSTest(portName, true, PORT3, STSPORT);
        this.runKerberosSTSTest(portName, false, PORT3, STAX_STSPORT);
        this.runKerberosSTSTest(portName, true, PORT3, STAX_STSPORT);
    }

    private void runKerberosTest(String portName, boolean streaming, String portNumber) throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, portName);
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        TestUtil.updateAddressPort((Object)kerberosPort, (String)portNumber);
        if (streaming) {
            SecurityTestUtil.enableStreaming(kerberosPort);
        }
        Assert.assertEquals((long)50L, (long)kerberosPort.doubleIt(25));
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    private void runKerberosSTSTest(String portName, boolean streaming, String portNumber, String stsPortNumber) throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("sts-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, portName);
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        TestUtil.updateAddressPort((Object)kerberosPort, (String)portNumber);
        SecurityTestUtil.updateSTSPort((BindingProvider)kerberosPort, stsPortNumber);
        if (streaming) {
            SecurityTestUtil.enableStreaming(kerberosPort);
        }
        Assert.assertEquals((long)50L, (long)kerberosPort.doubleIt(25));
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }
}

