/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.sse;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.sse.Book;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;

public abstract class AbstractSseBaseTest
extends AbstractBusClientServerTestBase {
    private final ObjectMapper mapper = new ObjectMapper();

    protected String toJson(String name, Integer id) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)new Book(name, id));
    }

    protected WebClient createWebClient(String url, String media) {
        List<JacksonJsonProvider> providers = Arrays.asList(new JacksonJsonProvider());
        WebClient wc = WebClient.create((String)("http://localhost:" + this.getPort() + url), providers).accept(new String[]{media});
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(8000L);
        return wc;
    }

    protected WebClient createWebClient(String url) {
        return this.createWebClient(url, "text/event-stream");
    }

    protected WebTarget createWebTarget(String url) {
        return ((Client)((Client)ClientBuilder.newClient().property("http.receive.timeout", (Object)8000)).register(JacksonJsonProvider.class)).target("http://localhost:" + this.getPort() + url);
    }

    protected void awaitEvents(int timeout, Collection<?> events, int size) throws InterruptedException {
        int sleep = timeout / 10;
        for (int i = 0; i < timeout && events.size() != size; i += sleep) {
            Thread.sleep(sleep);
        }
    }

    protected abstract int getPort();
}

