/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.sse;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.Headers;

@Provider
public class BookStoreResponseFilter
implements ContainerResponseFilter {
    private static AtomicInteger counter = new AtomicInteger(0);
    @Context
    private UriInfo uriInfo;

    public BookStoreResponseFilter() {
        counter.set(0);
    }

    public void filter(ContainerRequestContext reqContext, ContainerResponseContext rspContext) throws IOException {
        String path = this.uriInfo.getRequestUri().getPath();
        if (!path.endsWith("/filtered/stats")) {
            counter.incrementAndGet();
            if (path.endsWith("/headers/sse")) {
                rspContext.setStatus(202);
                rspContext.getHeaders().add((Object)"X-My-Header", (Object)"headers");
                Message message = JAXRSUtils.getCurrentMessage().getExchange().getOutMessage();
                Map headers = Headers.getSetProtocolHeaders((Message)message);
                headers.put("X-My-ProtocolHeader", Collections.singletonList("protocol-headers"));
            }
        }
    }

    public static int getInvocations() {
        return counter.get();
    }

    public static void reset() {
        counter.set(0);
    }
}

