/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.property_listener;

import com.sun.codemodel.JAssignment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import jakarta.xml.bind.annotation.XmlTransient;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;

public class PropertyListenerPlugin {
    private static final Logger LOG = Logger.getLogger(PropertyListenerPlugin.class.getName());

    public String getOptionName() {
        return "Xproperty-listener";
    }

    public String getUsage() {
        return "  -Xproperty-listener    : Adds a PropertyChangeListener to all the set methods";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        LOG.fine("Running property-listener plugin.");
        for (ClassOutline co : outline.getClasses()) {
            if (co.getDeclaredFields().length == 0) continue;
            JType listenerType = co.parent().getCodeModel()._ref(PropertyChangeSupport.class);
            JFieldVar newVar = co.implClass.field(2, listenerType, "propertyListener", (JExpression)JExpr._new((JType)listenerType).arg(JExpr._this()));
            newVar.annotate(XmlTransient.class);
            JMethod method = co.implClass.method(1, Void.TYPE, "addPropertyChangeListener");
            JVar listener = method.param(PropertyChangeListener.class, "listener");
            method.body().invoke((JExpression)newVar, "addPropertyChangeListener").arg((JExpression)listener);
            method = co.implClass.method(1, Void.TYPE, "removePropertyChangeListener");
            listener = method.param(PropertyChangeListener.class, "listener");
            method.body().invoke((JExpression)newVar, "removePropertyChangeListener").arg((JExpression)listener);
            List methods = (List)co.implClass.methods();
            for (int x = 0; x < methods.size(); ++x) {
                JMethod m = (JMethod)methods.get(x);
                if (!m.name().startsWith("set")) continue;
                m.body().pos(0);
                List contents = m.body().getContents();
                JFieldRef target = null;
                JExpression value = null;
                for (Object o : contents) {
                    if (!(o instanceof JAssignment)) continue;
                    JAssignment jass = (JAssignment)o;
                    try {
                        Field f = jass.getClass().getDeclaredField("lhs");
                        f.setAccessible(true);
                        Object t = f.get(jass);
                        if (!(t instanceof JFieldRef)) continue;
                        f = jass.getClass().getDeclaredField("rhs");
                        f.setAccessible(true);
                        value = (JExpression)f.get(jass);
                        target = (JFieldRef)t;
                    }
                    catch (Throwable f) {}
                }
                if (target == null) continue;
                try {
                    String targetName = this.getName(target);
                    JFieldVar field = (JFieldVar)co.implClass.fields().get(targetName);
                    if (value instanceof JVar) {
                        JVar var = (JVar)value;
                        JType t = var.type();
                        if ("int".equals(t.fullName()) && !"int".equals(field.type().fullName())) {
                            value = JExpr.cast((JType)co.parent().getCodeModel()._ref(Integer.class), (JExpression)value);
                        } else if ("boolean".equals(t.fullName()) && !"boolean".equals(field.type().fullName())) {
                            value = JExpr.cast((JType)co.parent().getCodeModel()._ref(Boolean.class), (JExpression)value);
                        }
                    }
                    m.body().invoke((JExpression)newVar, "firePropertyChange").arg(targetName).arg(target).arg(value);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return true;
    }

    String getName(JFieldRef ref) {
        try {
            Field f = ref.getClass().getDeclaredField("name");
            f.setAccessible(true);
            String targetName = (String)f.get(ref);
            if (targetName == null) {
                f = ref.getClass().getDeclaredField("var");
                f.setAccessible(true);
                JVar v = (JVar)f.get(ref);
                targetName = v.name();
            }
            return targetName;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

