/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.io.ByteArrayOutputStreamWithGetBuf;
import org.apache.daffodil.io.FileIOException;
import org.apache.daffodil.util.LogLevel;
import org.apache.daffodil.util.LogWriter;
import org.apache.daffodil.util.Logging;
import org.apache.daffodil.util.Maybe$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00055c!B\u000e\u001d\u0001q!\u0003\u0002\u0004\u001a\u0001\t\u0003\u0005)Q!A!\u0002\u0013!\u0004\u0002\u0004\u001e\u0001\t\u0003\u0005)Q!A!\u0002\u0013Y\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u000b)\u0003A\u0011A&\t\u000fM\u0003\u0001\u0019!C\u0001)\"9\u0001\f\u0001a\u0001\n\u0003I\u0006BB0\u0001A\u0003&Q\u000bC\u0004a\u0001\u0001\u0007I\u0011A1\t\u000f\r\u0004\u0001\u0019!C\u0001I\"1a\r\u0001Q!\n\tD\u0001b\u001a\u0001\t\u0006\u0004%\t\u0001\u0016\u0005\bQ\u0002\u0001\r\u0011\"\u0001j\u0011\u001dQ\u0007\u00011A\u0005\u0002-Da!\u001c\u0001!B\u0013!\u0004b\u00028\u0001\u0001\u0004%\ta\u001c\u0005\ba\u0002\u0001\r\u0011\"\u0001r\u0011\u0019\u0019\b\u0001)Q\u0005K!)A\u000f\u0001C\u0005k\")A\u0010\u0001C!{\"1A\u0010\u0001C!\u0003\u001bAa\u0001 \u0001\u0005B\u0005}\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u0002J\u0001!\t%a\u0013\u00037\tKH/Z!se\u0006LxJ\u001d$jY\u0016|U\u000f\u001e9viN#(/Z1n\u0015\tib$\u0001\u0002j_*\u0011q\u0004I\u0001\tI\u00064gm\u001c3jY*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h'\r\u0001Q\u0005\f\t\u0003M)j\u0011a\n\u0006\u0003;!R\u0011!K\u0001\u0005U\u00064\u0018-\u0003\u0002,O\taq*\u001e;qkR\u001cFO]3b[B\u0011Q\u0006M\u0007\u0002])\u0011qFH\u0001\u0005kRLG.\u0003\u00022]\t9Aj\\4hS:<\u0017\u0001S8sO\u0012\n\u0007/Y2iK\u0012\"\u0017M\u001a4pI&dG%[8%\u0005f$X-\u0011:sCf|%OR5mK>+H\u000f];u'R\u0014X-Y7%I5\f\u0007PQ;gM\u0016\u00148+\u001b>f\u0013:\u0014\u0015\u0010^3t\u0007\u0001\u0001\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012A\u0001T8oO\u0006ytN]4%CB\f7\r[3%I\u00064gm\u001c3jY\u0012Jw\u000e\n\"zi\u0016\f%O]1z\u001fJ4\u0015\u000e\\3PkR\u0004X\u000f^*ue\u0016\fW\u000e\n\u0013uK6\u0004H)\u001b:QCRD\u0007C\u0001\u0014=\u0013\titE\u0001\u0003GS2,\u0017!E7bs\n,W\t_5ti&twMR5mKB\u0019Q\u0006\u0011\"\n\u0005\u0005s#!B'bs\n,\u0007CA\"I\u001b\u0005!%BA#G\u0003\u00111\u0017\u000e\\3\u000b\u0005\u001dC\u0013a\u00018j_&\u0011\u0011\n\u0012\u0002\u0005!\u0006$\b.\u0001\u0004=S:LGO\u0010\u000b\u0005\u0019:\u0003&\u000b\u0005\u0002N\u00015\tA\u0004C\u0003P\t\u0001\u0007A'\u0001\u000bnCb\u0014UO\u001a4feNK'0Z%o\u0005f$Xm\u001d\u0005\u0006#\u0012\u0001\raO\u0001\fi\u0016l\u0007\u000fR5s!\u0006$\b\u000eC\u0003?\t\u0001\u0007q(\u0001\u0004jg\u001aKG.Z\u000b\u0002+B\u0011QGV\u0005\u0003/Z\u0012qAQ8pY\u0016\fg.\u0001\u0006jg\u001aKG.Z0%KF$\"AW/\u0011\u0005UZ\u0016B\u0001/7\u0005\u0011)f.\u001b;\t\u000fy3\u0011\u0011!a\u0001+\u0006\u0019\u0001\u0010J\u0019\u0002\u000f%\u001ch)\u001b7fA\u0005IQ.Y=cK\u001aKG.Z\u000b\u0002EB\u0019Q\u0006Q\u001e\u0002\u001b5\f\u0017PY3GS2,w\fJ3r)\tQV\rC\u0004_\u0013\u0005\u0005\t\u0019\u00012\u0002\u00155\f\u0017PY3GS2,\u0007%\u0001\u0006jgR+W\u000e\u001d$jY\u0016\faA\u001c\"zi\u0016\u001cX#\u0001\u001b\u0002\u00159\u0014\u0015\u0010^3t?\u0012*\u0017\u000f\u0006\u0002[Y\"9a,DA\u0001\u0002\u0004!\u0014a\u00028CsR,7\u000fI\u0001\u0007gR\u0014X-Y7\u0016\u0003\u0015\n!b\u001d;sK\u0006lw\fJ3r)\tQ&\u000fC\u0004_!\u0005\u0005\t\u0019A\u0013\u0002\u000fM$(/Z1nA\u0005Y1\r[3dW\n+hMZ3s)\tQf\u000fC\u0003x%\u0001\u0007A'A\u0007mK:<G\u000f[%o\u0005f$Xm\u001d\u0015\u0003%e\u0004\"!\u000e>\n\u0005m4$AB5oY&tW-A\u0003xe&$X\r\u0006\u0002[}\"1qp\u0005a\u0001\u0003\u0003\t\u0011A\u0019\t\u0006k\u0005\r\u0011qA\u0005\u0004\u0003\u000b1$!B!se\u0006L\bcA\u001b\u0002\n%\u0019\u00111\u0002\u001c\u0003\t\tKH/\u001a\u000b\b5\u0006=\u0011\u0011CA\u000e\u0011\u0019yH\u00031\u0001\u0002\u0002!9\u00111\u0003\u000bA\u0002\u0005U\u0011aA8gMB\u0019Q'a\u0006\n\u0007\u0005eaGA\u0002J]RDq!!\b\u0015\u0001\u0004\t)\"A\u0002mK:$2AWA\u0011\u0011\u0019yX\u00031\u0001\u0002\u0016\u0005)1\r\\8tKR\t!,\u0001\u0004hKR\u0014UO\u001a\u000b\u0003\u0003\u0003\tqaZ3u\r&dW-F\u0001<\u0003\u001dAW\r\u001f#v[B,\"!a\r\u0011\t\u0005U\u00121\t\b\u0005\u0003o\ty\u0004E\u0002\u0002:Yj!!a\u000f\u000b\u0007\u0005u2'\u0001\u0004=e>|GOP\u0005\u0004\u0003\u00032\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002F\u0005\u001d#AB*ue&twMC\u0002\u0002BY\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003g\u0001")
public class ByteArrayOrFileOutputStream
extends OutputStream
implements Logging {
    private boolean isTempFile;
    public final long org$apache$daffodil$io$ByteArrayOrFileOutputStream$$maxBufferSizeInBytes;
    public final File org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath;
    private Object maybeExistingFile;
    private boolean isFile;
    private Object maybeFile;
    private long nBytes;
    private OutputStream stream;
    private String logID;
    private Object logWriter;
    private Object logLevel;
    private volatile byte bitmap$0;

    public void setLoggingLevel(LogLevel.Type level) {
        Logging.setLoggingLevel$((Logging)this, (LogLevel.Type)level);
    }

    public final LogLevel.Type getLoggingLevel() {
        return Logging.getLoggingLevel$((Logging)this);
    }

    public void setLogWriter(LogWriter lw) {
        Logging.setLogWriter$((Logging)this, (LogWriter)lw);
    }

    public LogWriter getLogWriter() {
        return Logging.getLogWriter$((Logging)this);
    }

    public final boolean areLogging(LogLevel.Type lvl) {
        return Logging.areLogging$((Logging)this, (LogLevel.Type)lvl);
    }

    public void doLogging(LogLevel.Type lvl, String msg, Seq<Object> args) {
        Logging.doLogging$((Logging)this, (LogLevel.Type)lvl, (String)msg, args);
    }

    public <S> LogLevel.Type withLoggingLevel$default$1() {
        return Logging.withLoggingLevel$default$1$((Logging)this);
    }

    private String logID$lzycompute() {
        ByteArrayOrFileOutputStream byteArrayOrFileOutputStream = this;
        synchronized (byteArrayOrFileOutputStream) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logID = Logging.logID$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logID;
    }

    public String logID() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logID$lzycompute() : this.logID;
    }

    public Object logWriter() {
        return this.logWriter;
    }

    public void logWriter_$eq(Object x$1) {
        this.logWriter = x$1;
    }

    public Object logLevel() {
        return this.logLevel;
    }

    public void logLevel_$eq(Object x$1) {
        this.logLevel = x$1;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public void isFile_$eq(boolean x$1) {
        this.isFile = x$1;
    }

    public Object maybeFile() {
        return this.maybeFile;
    }

    public void maybeFile_$eq(Object x$1) {
        this.maybeFile = x$1;
    }

    private boolean isTempFile$lzycompute() {
        ByteArrayOrFileOutputStream byteArrayOrFileOutputStream = this;
        synchronized (byteArrayOrFileOutputStream) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.isTempFile = !Maybe$.MODULE$.isDefined$extension(this.maybeExistingFile) && this.isFile();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.maybeExistingFile = null;
        return this.isTempFile;
    }

    public boolean isTempFile() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.isTempFile$lzycompute() : this.isTempFile;
    }

    public long nBytes() {
        return this.nBytes;
    }

    public void nBytes_$eq(long x$1) {
        this.nBytes = x$1;
    }

    public OutputStream stream() {
        return this.stream;
    }

    public void stream_$eq(OutputStream x$1) {
        this.stream = x$1;
    }

    private void checkBuffer(long lengthInBytes) {
        if (!this.isFile() && this.nBytes() + lengthInBytes > this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$maxBufferSizeInBytes) {
            BoxedUnit boxedUnit;
            LogLevel.Info$ fresh$macro$1 = LogLevel.Info$.MODULE$;
            int fresh$macro$2 = fresh$macro$1.lvl();
            if (this.getLoggingLevel().lvl() >= fresh$macro$2) {
                this.doLogging((LogLevel.Type)fresh$macro$1, "Switching to file based output stream. If this is performance critical, you may want to consider re-organizing your schema to avoid this if possible.", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.maybeFile_$eq(this.liftedTree1$1());
            FileOutputStream newStream = new FileOutputStream((File)Maybe$.MODULE$.get$extension(this.maybeFile()));
            this.stream().flush();
            ((ByteArrayOutputStreamWithGetBuf)this.stream()).writeTo(newStream);
            this.stream_$eq(newStream);
            this.isFile_$eq(true);
        } else {
            this.nBytes_$eq(this.nBytes() + lengthInBytes);
        }
    }

    @Override
    public void write(byte[] b) {
        this.checkBuffer(b.length);
        this.stream().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.checkBuffer(len);
        this.stream().write(b, off, len);
    }

    @Override
    public void write(int b) {
        this.checkBuffer(1L);
        this.stream().write(b);
    }

    @Override
    public void close() {
        this.stream().close();
    }

    public byte[] getBuf() {
        if (this.isFile()) {
            throw Assert$.MODULE$.abort2("Usage error: Attempted to call getBuf on FileOutputStream", "ByteArrayOrFileOutputStream.this.isFile.unary_!");
        }
        return ((ByteArrayOutputStreamWithGetBuf)this.stream()).getBuf();
    }

    public File getFile() {
        return (File)Maybe$.MODULE$.get$extension(this.maybeFile());
    }

    public String hexDump() {
        return this.isFile() ? ((File)Maybe$.MODULE$.get$extension(this.maybeFile())).toString() : ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), (int)this.nBytes() - 1).map((Function1 & Serializable & scala.Serializable)i -> ByteArrayOrFileOutputStream.$anonfun$hexDump$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public String toString() {
        return this.hexDump();
    }

    private final Object liftedTree1$1() {
        Object object;
        try {
            File file = File.createTempFile("daffodil-", ".tmp", this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath);
            file.deleteOnExit();
            object = Maybe$.MODULE$.apply((Object)file);
        }
        catch (Exception e) {
            throw new FileIOException(new StringOps(Predef$.MODULE$.augmentString("Unable to create temporary file in %s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath.getPath(), e.getMessage()})));
        }
        return object;
    }

    public static final /* synthetic */ String $anonfun$hexDump$1(ByteArrayOrFileOutputStream $this, int i) {
        return new StringOps(Predef$.MODULE$.augmentString("%2x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)($this.getBuf()[i] & 0xFF))}));
    }

    public ByteArrayOrFileOutputStream(long maxBufferSizeInBytes, File tempDirPath, Object maybeExistingFile) {
        this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$maxBufferSizeInBytes = maxBufferSizeInBytes;
        this.org$apache$daffodil$io$ByteArrayOrFileOutputStream$$tempDirPath = tempDirPath;
        this.maybeExistingFile = maybeExistingFile;
        Logging.$init$((Logging)this);
        this.isFile = Maybe$.MODULE$.isDefined$extension(maybeExistingFile);
        this.maybeFile = Maybe$.MODULE$.isDefined$extension(maybeExistingFile) ? Maybe$.MODULE$.apply((Object)((Path)Maybe$.MODULE$.get$extension(maybeExistingFile)).toFile()) : Maybe$.MODULE$.Nope();
        this.nBytes = 0L;
        this.stream = new ByteArrayOutputStreamWithGetBuf();
    }
}

