/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.regex.Matcher;
import org.apache.daffodil.io.DataInputStream;
import org.apache.daffodil.io.DataInputStreamImplMixin;
import org.apache.daffodil.io.DataStreamCommonImplMixin;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSource;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.io.InputSourceDataInputStreamCharIterator;
import org.apache.daffodil.io.LocalBufferMixin;
import org.apache.daffodil.io.MarkPool;
import org.apache.daffodil.io.MarkState;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.lib.schema.annotation.props.gen.ByteOrder;
import org.apache.daffodil.lib.util.Bits$;
import org.apache.daffodil.lib.util.LocalStack;
import org.apache.daffodil.lib.util.MStackOf;
import org.apache.daffodil.lib.util.Maybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.MaybeULong$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005x!B\u001d;\u0011\u0003\u0019e!B#;\u0011\u00031\u0005\"B'\u0002\t\u0003q\u0005\"B(\u0002\t\u0003\u0001\u0006BB(\u0002\t\u0003\u0011y\r\u0003\u0004P\u0003\u0011\u0005!Q\u001b\u0004\u0005\u000bj\u0012!\u000b\u0003\u0005^\r\t\u0015\r\u0011\"\u0001_\u0011!\u0011gA!A!\u0002\u0013y\u0006\"B'\u0007\t\u0013\u0019\u0007\"B3\u0007\t\u00032\u0007bB7\u0007\u0005\u0004%)E\u001c\u0005\u0007e\u001a\u0001\u000bQB8\t\u000fM4!\u0019!C\u0001i\"1QP\u0002Q\u0001\nUDqA \u0004C\u0002\u0013\u0005q\u0010\u0003\u0005\u0002\b\u0019\u0001\u000b\u0011BA\u0001\u0011\u001d\tIA\u0002C!\u0003\u0017Aq!a\u0005\u0007\t\u000b\n)\u0002C\u0004\u0002&\u0019!)%a\n\t\u000f\u0005Eb\u0001\"\u0001\u00024!9\u00111\b\u0004\u0005\u0002\u0005U\u0001bBA\u001f\r\u0011\u0005\u0011q\b\u0005\b\u0003\u000b2A\u0011IA$\u0011\u001d\tiE\u0002C\u0001\u0003\u001fBq!!\u0016\u0007\t\u0003\t9\u0006C\u0004\u0002V\u0019!\t!!\u001f\t\u000f\u0005\re\u0001\"\u0003\u0002\u0006\"9\u0011Q\u0012\u0004\u0005\u0002\u0005=\u0005bBAM\r\u0011\u0005\u00111\u0014\u0005\b\u0003K3A\u0011AAT\u0011%\tyK\u0002b\u0001\n\u0013\t\t\f\u0003\u0005\u00024\u001a\u0001\u000b\u0011BA-\u0011\u001d\t)L\u0002C\u0001\u0003oCq!!4\u0007\t\u0013\ty\rC\u0004\u0002Z\u001a!\t!a7\t\u000f\u00055h\u0001\"\u0001\u0002p\"9\u0011Q\u001f\u0004\u0005\u0006\u0005]\bbBA\u007f\r\u0011\u0015\u0011q \u0005\b\u0005\u00031A\u0011\u0001B\u0002\u0011\u001d\u0011IA\u0002C\u0001\u0005\u0017AqAa\r\u0007\t\u0013\u0011)\u0004C\u0004\u0003:\u0019!\tAa\u000f\t\u000f\t}b\u0001\"\u0001\u0003B!9!Q\t\u0004\u0005B\t\u001d\u0003b\u0002B(\r\u0011\u0005#\u0011\u000b\u0005\b\u0005/2A\u0011AA\u0006\u0011\u001d\u0011IF\u0002C\u0003\u00057B!B!\u001b\u0007\u0011\u000b\u0007I\u0011\u0001B6\u0011\u001d\u0011IH\u0002C\u0001\u0005wBqA!!\u0007\t\u0003\u0011\u0019\tC\u0005\u0003\u001a\u001a\u0011\r\u0011\"\u0003\u0003\u001c\"A!1\u0015\u0004!\u0002\u0013\u0011i\nC\u0004\u0003&\u001a!\tAa*\t\u000f\t=f\u0001\"\u0011\u00032\"9!q\u0017\u0004\u0005\u0002\te\u0006b\u0002Bc\r\u0011\u0005!qY\u0001\u001b\u0013:\u0004X\u000f^*pkJ\u001cW\rR1uC&s\u0007/\u001e;TiJ,\u0017-\u001c\u0006\u0003wq\n!![8\u000b\u0005ur\u0014\u0001\u00033bM\u001a|G-\u001b7\u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\u0002\u0001!\t!\u0015!D\u0001;\u0005iIe\u000e];u'>,(oY3ECR\f\u0017J\u001c9viN#(/Z1n'\t\tq\t\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u000bQ!\u00199qYf$2!\u0015Bf!\t!ea\u0005\u0003\u0007\u000fN3\u0006C\u0001#U\u0013\t)&H\u0001\rECR\f\u0017J\u001c9viN#(/Z1n\u00136\u0004H.T5yS:\u0004\"aV.\u000e\u0003aS!aO-\u000b\u0003i\u000bAA[1wC&\u0011A\f\u0017\u0002\n\u00072|7/Z1cY\u0016\f1\"\u001b8qkR\u001cv.\u001e:dKV\tq\f\u0005\u0002EA&\u0011\u0011M\u000f\u0002\f\u0013:\u0004X\u000f^*pkJ\u001cW-\u0001\u0007j]B,HoU8ve\u000e,\u0007\u0005\u0006\u0002RI\")Q,\u0003a\u0001?\u0006AAo\\*ue&tw\rF\u0001h!\tA7.D\u0001j\u0015\tQ\u0017,\u0001\u0003mC:<\u0017B\u00017j\u0005\u0019\u0019FO]5oO\u0006\u00191m\u001d;\u0016\u0003=\u0004\"\u0001\u00129\n\u0005ET$!C'be.\u001cF/\u0019;f\u0003\u0011\u00197\u000f\u001e\u0011\u0002\u00135\f'o[*uC\u000e\\W#A;\u0011\u0007Y\\x.D\u0001x\u0015\tA\u00180\u0001\u0003vi&d'B\u0001>=\u0003\ra\u0017NY\u0005\u0003y^\u0014\u0001\"T*uC\u000e\\wJZ\u0001\u000b[\u0006\u00148n\u0015;bG.\u0004\u0013\u0001C7be.\u0004vn\u001c7\u0016\u0005\u0005\u0005\u0001c\u0001#\u0002\u0004%\u0019\u0011Q\u0001\u001e\u0003\u00115\u000b'o\u001b)p_2\f\u0011\"\\1sWB{w\u000e\u001c\u0011\u0002\u000b\rdwn]3\u0015\u0005\u00055\u0001c\u0001%\u0002\u0010%\u0019\u0011\u0011C%\u0003\tUs\u0017\u000e^\u0001\tE&$\bk\\:1EV\u0011\u0011q\u0003\t\u0004\u0011\u0006e\u0011bAA\u000e\u0013\n!Aj\u001c8hQ\r\u0011\u0012q\u0004\t\u0004\u0011\u0006\u0005\u0012bAA\u0012\u0013\n1\u0011N\u001c7j]\u0016\f!BY5u\u0019&l\u0017\u000e\u001e\u0019c+\t\tI\u0003E\u0002w\u0003WI1!!\fx\u0005)i\u0015-\u001f2f+2{gn\u001a\u0015\u0004'\u0005}\u0011a\u00055bgJ+\u0017m\u00195fI\u0016sGm\u00144ECR\fWCAA\u001b!\rA\u0015qG\u0005\u0004\u0003sI%a\u0002\"p_2,\u0017M\\\u0001\u0014W:|wO\u001c\"zi\u0016\u001c\u0018I^1jY\u0006\u0014G.Z\u0001\fg\u0016$()\u001b;Q_N\u0004$\r\u0006\u0003\u0002\u000e\u0005\u0005\u0003bBA\"-\u0001\u0007\u0011qC\u0001\f]\u0016<()\u001b;Q_N\u0004$-A\u0007tKR\u0014\u0015\u000e\u001e'j[&$\bG\u0019\u000b\u0005\u0003k\tI\u0005C\u0004\u0002L]\u0001\r!!\u000b\u0002\u001b9,wOQ5u\u0019&l\u0017\u000e\u001e\u0019c\u0003=\u0011Xm]3u\u0005&$H*[7jiB\u0012G\u0003BA\u0007\u0003#Bq!a\u0015\u0019\u0001\u0004\tI#A\btCZ,GMQ5u\u0019&l\u0017\u000e\u001e\u0019c\u000319W\r\u001e\"zi\u0016\f%O]1z)\u0019\tI&!\u001a\u0002pA)\u0001*a\u0017\u0002`%\u0019\u0011QL%\u0003\u000b\u0005\u0013(/Y=\u0011\u0007!\u000b\t'C\u0002\u0002d%\u0013AAQ=uK\"9\u0011qM\rA\u0002\u0005%\u0014A\u00042ji2+gn\u001a;i\rJ|W.\r\t\u0004\u0011\u0006-\u0014bAA7\u0013\n\u0019\u0011J\u001c;\t\u000f\u0005E\u0014\u00041\u0001\u0002t\u0005)a-\u001b8g_B\u0019A)!\u001e\n\u0007\u0005]$H\u0001\u0006G_Jl\u0017\r^%oM>$\u0002\"!\u0004\u0002|\u0005u\u0014q\u0010\u0005\b\u0003OR\u0002\u0019AA5\u0011\u001d\t\tH\u0007a\u0001\u0003gBq!!!\u001b\u0001\u0004\tI&A\u0003beJ\f\u00170A\u0007gS2d')\u001f;f\u0003J\u0014\u0018-\u001f\u000b\t\u0003\u001b\t9)!#\u0002\f\"9\u0011\u0011Q\u000eA\u0002\u0005e\u0003bBA47\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003cZ\u0002\u0019AA:\u0003=9W\r\u001e\"j]\u0006\u0014\u0018\u0010R8vE2,G\u0003BAI\u0003/\u00032\u0001SAJ\u0013\r\t)*\u0013\u0002\u0007\t>,(\r\\3\t\u000f\u0005ED\u00041\u0001\u0002t\u0005qq-\u001a;CS:\f'/\u001f$m_\u0006$H\u0003BAO\u0003G\u00032\u0001SAP\u0013\r\t\t+\u0013\u0002\u0006\r2|\u0017\r\u001e\u0005\b\u0003cj\u0002\u0019AA:\u000359W\r^*jO:,G\rT8oOR1\u0011qCAU\u0003[Cq!a+\u001f\u0001\u0004\tI'\u0001\ncSRdUM\\4uQ\u001a\u0013x.\\\u0019U_Z\"\u0004bBA9=\u0001\u0007\u00111O\u0001\nY>tw-\u0011:sCf,\"!!\u0017\u0002\u00151|gnZ!se\u0006L\b%A\bhKR,fn]5h]\u0016$Gj\u001c8h)\u0019\tI,!3\u0002LB!\u00111XAc\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017\u0001C;og&<g.\u001a3\u000b\u0005\u0005\r\u0017a\u00029bgN,'/Y\u0005\u0005\u0003\u000f\fiLA\u0003V\u0019>tw\rC\u0004\u0002,\u0006\u0002\r!!\u001b\t\u000f\u0005E\u0014\u00051\u0001\u0002t\u0005\t\u0013\r\u001a6vgR\u0014\u0015nZ%oi\u0006\u0013(/Y=XSRDgI]1h[\u0016tGOQ=uKRA\u0011QBAi\u0003'\f9\u000eC\u0004\u0002\u0002\n\u0002\r!!\u0017\t\u000f\u0005U'\u00051\u0001\u0002j\u0005qaM]1h[\u0016tG\u000fT3oORD\u0007bBA9E\u0001\u0007\u00111O\u0001\u0010O\u0016$8+[4oK\u0012\u0014\u0015nZ%oiR1\u0011Q\\Au\u0003W\u0004B!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0004\u0003GL\u0016\u0001B7bi\"LA!a:\u0002b\nQ!)[4J]R,w-\u001a:\t\u000f\u0005\u001d4\u00051\u0001\u0002j!9\u0011\u0011O\u0012A\u0002\u0005M\u0014!E4fiVs7/[4oK\u0012\u0014\u0015nZ%oiR1\u0011Q\\Ay\u0003gDq!a\u001a%\u0001\u0004\tI\u0007C\u0004\u0002r\u0011\u0002\r!a\u001d\u0002%%\u001cH)\u001a4j]\u0016$gi\u001c:MK:<G\u000f\u001b\u000b\u0005\u0003k\tI\u0010C\u0004\u0002|\u0016\u0002\r!a\u0006\u0002\u000b9\u0014\u0015\u000e^:\u0002\u000f!\f7\u000fR1uCR\u0011\u0011QG\u0001\u0005g.L\u0007\u000f\u0006\u0004\u00026\t\u0015!q\u0001\u0005\b\u0003w<\u0003\u0019AA\f\u0011\u001d\t\th\na\u0001\u0003g\nA!\\1sWR!!Q\u0002B\u000e!\u0011\u0011yA!\u0006\u000f\u0007\u0011\u0013\t\"C\u0002\u0003\u0014i\nq\u0002R1uC&s\u0007/\u001e;TiJ,\u0017-\\\u0005\u0005\u0005/\u0011IB\u0001\u0003NCJ\\'b\u0001B\nu!9!Q\u0004\u0015A\u0002\t}\u0011a\u0003:fcV,7\u000f^8s\u0013\u0012\u0003BA!\t\u000309!!1\u0005B\u0016!\r\u0011)#S\u0007\u0003\u0005OQ1A!\u000bC\u0003\u0019a$o\\8u}%\u0019!QF%\u0002\rA\u0013X\rZ3g\u0013\ra'\u0011\u0007\u0006\u0004\u0005[I\u0015\u0001\u0005:fY\u0016\f7/Z+oi&dW*\u0019:l)\ry'q\u0007\u0005\b\u0005\u0013I\u0003\u0019\u0001B\u0007\u0003\u0015\u0011Xm]3u)\u0011\tiA!\u0010\t\u000f\t%!\u00061\u0001\u0003\u000e\u00059A-[:dCJ$G\u0003BA\u0007\u0005\u0007BqA!\u0003,\u0001\u0004\u0011i!A\u0004nCJ\\\u0007k\\:\u0016\u0005\t%\u0003\u0003\u0002B\b\u0005\u0017JAA!\u0014\u0003\u001a\t9Q*\u0019:l!>\u001c\u0018\u0001\u0003:fg\u0016$\bk\\:\u0015\t\u00055!1\u000b\u0005\b\u0005+j\u0003\u0019\u0001B%\u0003\u0005i\u0017\u0001\u0007<bY&$\u0017\r^3GS:\fGn\u0015;sK\u0006l7\u000b^1uK\u0006iq-\u001a;T_6,7\u000b\u001e:j]\u001e$bA!\u0018\u0003d\t\u001d\u0004#\u0002<\u0003`\t}\u0011b\u0001B1o\n)Q*Y=cK\"9!QM\u0018A\u0002\u0005]\u0011A\u00028DQ\u0006\u00148\u000fC\u0004\u0002r=\u0002\r!a\u001d\u0002\u001dM\\\u0017\u000e]\"iCJ\u0014UO\u001a4feV\u0011!Q\u000e\t\u0005\u0005_\u0012)(\u0004\u0002\u0003r)\u0019!1O-\u0002\u00079Lw.\u0003\u0003\u0003x\tE$AC\"iCJ\u0014UO\u001a4fe\u0006I1o[5q\u0007\"\f'o\u001d\u000b\u0007\u0003k\u0011iHa \t\u000f\t\u0015\u0014\u00071\u0001\u0002\u0018!9\u0011\u0011O\u0019A\u0002\u0005M\u0014!\u00037p_.LgnZ!u)\u0019\t)D!\"\u0003\u0018\"9!q\u0011\u001aA\u0002\t%\u0015aB7bi\u000eDWM\u001d\t\u0005\u0005\u0017\u0013\u0019*\u0004\u0002\u0003\u000e*!!q\u0012BI\u0003\u0015\u0011XmZ3y\u0015\tA\u0018,\u0003\u0003\u0003\u0016\n5%aB'bi\u000eDWM\u001d\u0005\b\u0003c\u0012\u0004\u0019AA:\u00031\u0019\u0007.\u0019:Ji\u0016\u0014\u0018\r^8s+\t\u0011i\nE\u0002E\u0005?K1A!);\u0005\u0019Je\u000e];u'>,(oY3ECR\f\u0017J\u001c9viN#(/Z1n\u0007\"\f'/\u0013;fe\u0006$xN]\u0001\u000eG\"\f'/\u0013;fe\u0006$xN\u001d\u0011\u0002\u001d\u0005\u001c\u0018\n^3sCR|'o\u00115beV\u0011!\u0011\u0016\t\u0005\u0005\u001f\u0011Y+\u0003\u0003\u0003.\ne!\u0001D\"iCJLE/\u001a:bi>\u0014\u0018\u0001D:fi\u0012+'-^4hS:<G\u0003BA\u0007\u0005gCqA!.7\u0001\u0004\t)$A\u0004tKR$\u0018N\\4\u0002\u0011A\f7\u000f\u001e#bi\u0006$BAa/\u0003BB!!q\u000eB_\u0013\u0011\u0011yL!\u001d\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u0003D^\u0002\r!!\u001b\u0002\u001f9\u0014\u0015\u0010^3t%\u0016\fX/Z:uK\u0012\f!BZ;ukJ,G)\u0019;b)\u0011\u0011YL!3\t\u000f\t\r\u0007\b1\u0001\u0002j!9!QZ\u0002A\u0002\u0005e\u0013!\u00032zi\u0016\f%O]1z)\r\t&\u0011\u001b\u0005\b\u0005'$\u0001\u0019\u0001B^\u0003)\u0011\u0017\u0010^3Ck\u001a4WM\u001d\u000b\u0004#\n]\u0007b\u0002Bm\u000b\u0001\u0007!1\\\u0001\u0003S:\u00042a\u0016Bo\u0013\r\u0011y\u000e\u0017\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e")
public final class InputSourceDataInputStream
implements DataInputStreamImplMixin,
Closeable {
    private CharBuffer skipCharBuffer;
    private final InputSource inputSource;
    private final MarkState cst;
    private final MStackOf<MarkState> markStack;
    private final MarkPool markPool;
    private final byte[] longArray;
    private final InputSourceDataInputStreamCharIterator charIterator;
    private LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer;
    private LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer;
    private volatile byte bitmap$0;

    public static InputSourceDataInputStream apply(InputStream inputStream) {
        return InputSourceDataInputStream$.MODULE$.apply(inputStream);
    }

    public static InputSourceDataInputStream apply(ByteBuffer byteBuffer) {
        return InputSourceDataInputStream$.MODULE$.apply(byteBuffer);
    }

    public static InputSourceDataInputStream apply(byte[] byArray) {
        return InputSourceDataInputStream$.MODULE$.apply(byArray);
    }

    @Override
    public final boolean isAligned(int bitAlignment1b) {
        return DataInputStreamImplMixin.isAligned$(this, bitAlignment1b);
    }

    @Override
    public final boolean align(int bitAlignment1b, FormatInfo finfo) {
        return DataInputStreamImplMixin.align$(this, bitAlignment1b, finfo);
    }

    @Override
    public final boolean areDebugging() {
        return DataStreamCommonImplMixin.areDebugging$(this);
    }

    @Override
    public final long bitPos1b() {
        return DataInputStream.bitPos1b$(this);
    }

    @Override
    public final long bytePos0b() {
        return DataInputStream.bytePos0b$(this);
    }

    @Override
    public final long bytePos1b() {
        return DataInputStream.bytePos1b$(this);
    }

    @Override
    public final long bitLimit1b() {
        return DataInputStream.bitLimit1b$(this);
    }

    @Override
    public final boolean setBitLimit1b(long bitLimit1b) {
        return DataInputStream.setBitLimit1b$(this, bitLimit1b);
    }

    private LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.withLocalCharBuffer = LocalBufferMixin.withLocalCharBuffer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.withLocalCharBuffer;
    }

    @Override
    public final LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.withLocalCharBuffer$lzycompute();
        }
        return this.withLocalCharBuffer;
    }

    private LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.withLocalByteBuffer = LocalBufferMixin.withLocalByteBuffer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.withLocalByteBuffer;
    }

    @Override
    public final LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.withLocalByteBuffer$lzycompute();
        }
        return this.withLocalByteBuffer;
    }

    public InputSource inputSource() {
        return this.inputSource;
    }

    public String toString() {
        long bp0b = this.bitPos0b();
        long bl0b = this.bitLimit0b();
        String bl0b1 = MaybeULong$.MODULE$.isDefined$extension(bl0b) ? Long.toString(MaybeULong$.MODULE$.get$extension(bl0b)) : "none";
        String str = new StringBuilder(35).append("DataInputStream(bitPos=").append(bp0b).append(", bitLimit=").append(bl0b1).append(")").toString();
        return str;
    }

    @Override
    public final MarkState cst() {
        return this.cst;
    }

    public MStackOf<MarkState> markStack() {
        return this.markStack;
    }

    public MarkPool markPool() {
        return this.markPool;
    }

    @Override
    public void close() {
        this.inputSource().close();
    }

    @Override
    public final long bitPos0b() {
        return this.cst().bitPos0b();
    }

    @Override
    public final long bitLimit0b() {
        return this.cst().bitLimit0b();
    }

    public boolean hasReachedEndOfData() {
        return this.inputSource().hasReachedEndOfData();
    }

    public long knownBytesAvailable() {
        return this.inputSource().knownBytesAvailable();
    }

    public void setBitPos0b(long newBitPos0b) {
        if (newBitPos0b < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitPos0b.>=(0)");
        }
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            throw Assert$.MODULE$.abort("Invariant broken: InputSourceDataInputStream.this.bitLimit0b.isEmpty.||(newBitPos0b.<=(InputSourceDataInputStream.this.bitLimit0b.get))");
        }
        this.inputSource().position(newBitPos0b >> 3);
        this.cst().bitPos0b_$eq(newBitPos0b);
    }

    @Override
    public boolean setBitLimit0b(long newBitLimit0b) {
        if (!MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) && MaybeULong$.MODULE$.get$extension(newBitLimit0b) < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitLimit0b.isEmpty.||(newBitLimit0b.get.>=(0))");
        }
        if (MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) || MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) || MaybeULong$.MODULE$.get$extension(newBitLimit0b) <= MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            this.cst().bitLimit0b_$eq(newBitLimit0b);
            return true;
        }
        return false;
    }

    @Override
    public void resetBitLimit0b(long savedBitLimit0b) {
        this.cst().bitLimit0b_$eq(savedBitLimit0b);
    }

    @Override
    public byte[] getByteArray(int bitLengthFrom1, FormatInfo finfo) {
        if (!this.isDefinedForLength(bitLengthFrom1)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1);
        }
        int arraySize = (bitLengthFrom1 + 7) / 8;
        byte[] array = new byte[arraySize];
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
        return array;
    }

    @Override
    public void getByteArray(int bitLengthFrom1, FormatInfo finfo, byte[] array) {
        if (!this.isDefinedForLength(bitLengthFrom1)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1);
        }
        int bytesNeeded = (bitLengthFrom1 + 7) / 8;
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).size() < bytesNeeded) {
            throw Assert$.MODULE$.usageError("Usage error: scala.Predef.byteArrayOps(array).size.>=(bytesNeeded)");
        }
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
    }

    private void fillByteArray(byte[] array, int bitLengthFrom1, FormatInfo finfo) {
        boolean isUnaligned = !this.isAligned(8);
        int fragmentBits = bitLengthFrom1 % 8;
        int bytesToFill = (bitLengthFrom1 + 7) / 8;
        this.inputSource().get(array, 0, bytesToFill);
        if (isUnaligned) {
            int index;
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
            boolean isMSBF = !(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null);
            int bitOffset0b = (int)(this.bitPos0b() % 8L);
            int bytesToRead = (bitLengthFrom1 + bitOffset0b + 7) / 8;
            int arrayOverflow = bytesToRead > bytesToFill ? Bits$.MODULE$.asUnsignedByte((long)this.inputSource().get()) : 0;
            int curBitMask = isMSBF ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(8 - bitOffset0b)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(8 - bitOffset0b));
            int nxtBitMask = ~curBitMask & 0xFF;
            int curShift = bitOffset0b;
            int nxtShift = 8 - bitOffset0b;
            int curByte = Bits$.MODULE$.asUnsignedByte(array[index]);
            int stopIndex = bytesToFill - 1;
            for (index = 0; index < stopIndex; ++index) {
                int nxtByte = Bits$.MODULE$.asUnsignedByte(array[index + 1]);
                array[index] = InputSourceDataInputStream.calcNewByte$1(curByte, nxtByte, curBitMask, nxtBitMask, isMSBF, curShift, nxtShift);
                curByte = nxtByte;
            }
            array[index] = InputSourceDataInputStream.calcNewByte$1(curByte, arrayOverflow, curBitMask, nxtBitMask, isMSBF, curShift, nxtShift);
        }
        if (fragmentBits > 0) {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
            int mask = !(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null) ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(fragmentBits)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(fragmentBits));
            int lastIndex = bytesToFill - 1;
            int lastByte = Bits$.MODULE$.asUnsignedByte(array[lastIndex]);
            array[lastIndex] = Bits$.MODULE$.asSignedByte((long)(lastByte & mask));
        }
        if (bitLengthFrom1 > 8) {
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
                Bits$.MODULE$.reverseBytes(array, bytesToFill);
                return;
            }
        }
    }

    @Override
    public double getBinaryDouble(FormatInfo finfo) {
        long l = this.getSignedLong(64, finfo);
        double d = Double.longBitsToDouble(l);
        return d;
    }

    @Override
    public float getBinaryFloat(FormatInfo finfo) {
        int i = (int)this.getSignedLong(32, finfo);
        float f = Float.intBitsToFloat(i);
        return f;
    }

    @Override
    public long getSignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1To64.<=(64)");
        }
        long res = this.getUnsignedLong(bitLengthFrom1To64, finfo);
        return Bits$.MODULE$.signExtend(res, bitLengthFrom1To64);
    }

    private byte[] longArray() {
        return this.longArray;
    }

    @Override
    public long getUnsignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        long l;
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1To64.<=(64)");
        }
        if (!this.isDefinedForLength(bitLengthFrom1To64)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1To64);
        }
        int numBytes = (bitLengthFrom1To64 + 7) / 8;
        this.fillByteArray(this.longArray(), bitLengthFrom1To64, finfo);
        int fragmentLength = bitLengthFrom1To64 % 8;
        if (fragmentLength == 0) {
            long l2;
            l = l2 = this.buildLongFromArray$1(numBytes);
        } else {
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
                long l3;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null)) {
                    int firstByte = Bits$.MODULE$.asUnsignedByte(this.longArray()[0]);
                    int shifted = firstByte >>> 8 - fragmentLength;
                    this.longArray()[0] = Bits$.MODULE$.asSignedByte((long)shifted);
                }
                l = l3 = this.buildLongFromArray$1(numBytes);
            } else {
                long l4;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.LeastSignificantBitFirst$ leastSignificantBitFirst$ = BitOrder.LeastSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(leastSignificantBitFirst$) : leastSignificantBitFirst$ != null)) {
                    int lastIndex = numBytes - 1;
                    byte lastByte = this.longArray()[lastIndex];
                    int shifted = lastByte << 8 - fragmentLength;
                    this.longArray()[lastIndex] = Bits$.MODULE$.asSignedByte((long)shifted);
                }
                long unShiftedLong = this.buildLongFromArray$1(numBytes);
                l = l4 = unShiftedLong >>> 8 - fragmentLength;
            }
        }
        long res = l;
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1To64);
        return res;
    }

    private void adjustBigIntArrayWithFragmentByte(byte[] array, int fragmentLength, FormatInfo finfo) {
        ByteOrder byteOrder = finfo.byteOrder();
        ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
        if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
            if (!(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null)) {
                int firstByte = Bits$.MODULE$.asUnsignedByte(array[0]);
                int shifted = firstByte >>> 8 - fragmentLength;
                array[0] = Bits$.MODULE$.asSignedByte((long)shifted);
                return;
            }
            return;
        }
        BitOrder bitOrder = finfo.bitOrder();
        BitOrder.LeastSignificantBitFirst$ leastSignificantBitFirst$ = BitOrder.LeastSignificantBitFirst$.MODULE$;
        if (!(bitOrder != null ? !bitOrder.equals(leastSignificantBitFirst$) : leastSignificantBitFirst$ != null)) {
            int lastIndex = array.length - 1;
            byte lastByte = array[lastIndex];
            int shifted = lastByte << 8 - fragmentLength;
            array[lastIndex] = Bits$.MODULE$.asSignedByte((long)shifted);
        }
        ByteBuffer bb = ByteBuffer.wrap(array);
        Bits$.MODULE$.shiftRight(bb, 8 - fragmentLength);
    }

    @Override
    public BigInteger getSignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1.>=(1)");
        }
        if (bitLengthFrom1 <= 64) {
            return BigInteger.valueOf(this.getSignedLong(bitLengthFrom1, finfo));
        }
        byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
        int fragmentLength = bitLengthFrom1 % 8;
        if (fragmentLength > 0) {
            this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
            int shift = 8 - fragmentLength;
            bytes[0] = (byte)((byte)(bytes[0] << shift) >> shift);
        }
        return new BigInteger(bytes);
    }

    @Override
    public BigInteger getUnsignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.usageError("Usage error: bitLengthFrom1.>=(1)");
        }
        byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
        int fragmentLength = bitLengthFrom1 % 8;
        if (fragmentLength > 0) {
            this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
        }
        return new BigInteger(1, bytes);
    }

    @Override
    public final boolean isDefinedForLength(long nBits) {
        long newBitPos0b = this.bitPos0b() + nBits;
        if (MaybeULong$.MODULE$.isDefined$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            return false;
        }
        long newEndingBytePos0b = Bits$.MODULE$.roundUpBitToBytePosition(newBitPos0b);
        long moreBytesNeeded = newEndingBytePos0b - this.inputSource().position();
        return this.inputSource().areBytesAvailable(moreBytesNeeded);
    }

    @Override
    public final boolean hasData() {
        return this.isDefinedForLength(1L);
    }

    @Override
    public boolean skip(long nBits, FormatInfo finfo) {
        if (!this.isDefinedForLength(nBits)) {
            return false;
        }
        this.setBitPos0b(this.bitPos0b() + nBits);
        return true;
    }

    @Override
    public DataInputStream.Mark mark(String requestorID) {
        MarkState m = (MarkState)this.markPool().getFromPool(requestorID);
        m.assignFrom(this.cst());
        this.markStack().push((Object)m);
        this.inputSource().lockPosition(m.bytePos0b());
        return m;
    }

    private MarkState releaseUntilMark(DataInputStream.Mark mark) {
        if (this.markStack().isEmpty()) {
            throw Assert$.MODULE$.usageError("Usage error: InputSourceDataInputStream.this.markStack.isEmpty.unary_!");
        }
        if (mark == null) {
            throw Assert$.MODULE$.usageError("Usage error: mark.!=(null)");
        }
        MarkState current = (MarkState)this.markStack().pop();
        while (!this.markStack().isEmpty() && current != mark) {
            this.inputSource().releasePosition(current.bytePos0b());
            this.markPool().returnToPool(current);
            current = (MarkState)this.markStack().pop();
        }
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        return current;
    }

    @Override
    public void reset(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.cst().assignFrom(current);
        this.setBitPos0b(this.cst().bitPos0b());
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public void discard(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public long markPos() {
        return this.bitPos0b();
    }

    @Override
    public void resetPos(long m) {
        this.setBitPos0b(m);
    }

    public void validateFinalStreamState() {
        this.markPool().finalCheck();
    }

    @Override
    public final Object getSomeString(long nChars, FormatInfo finfo) {
        long startingBitPos = this.bitPos0b();
        return ((Maybe)this.withLocalCharBuffer().apply((Function1 & Serializable & scala.Serializable)lcb -> new Maybe(InputSourceDataInputStream.$anonfun$getSomeString$1(this, nChars, finfo, startingBitPos, lcb)))).v();
    }

    private CharBuffer skipCharBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.skipCharBuffer = CharBuffer.allocate(32);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.skipCharBuffer;
    }

    public CharBuffer skipCharBuffer() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.skipCharBuffer$lzycompute();
        }
        return this.skipCharBuffer;
    }

    @Override
    public boolean skipChars(long nChars, FormatInfo finfo) {
        boolean skippedAllNChars;
        block2: {
            long remainingCharsToSkip;
            int numDecoded;
            long startingBitPos = this.bitPos0b();
            boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
            if (!aligned) {
                return false;
            }
            boolean keepGoing = true;
            for (remainingCharsToSkip = nChars; keepGoing && remainingCharsToSkip > 0L; remainingCharsToSkip -= (long)numDecoded) {
                long charsToSkip = Math.min(remainingCharsToSkip, (long)this.skipCharBuffer().capacity());
                this.skipCharBuffer().position(0);
                this.skipCharBuffer().limit((int)charsToSkip);
                BitsCharsetDecoder qual$1 = finfo.decoder();
                InputSourceDataInputStream x$1 = this;
                FormatInfo x$2 = finfo;
                CharBuffer x$3 = this.skipCharBuffer();
                LongBuffer x$4 = qual$1.decode$default$4();
                numDecoded = qual$1.decode(x$1, x$2, x$3, x$4);
                if (numDecoded != 0) continue;
                keepGoing = false;
            }
            boolean bl = skippedAllNChars = remainingCharsToSkip == 0L;
            if (skippedAllNChars) break block2;
            this.setBitPos0b(startingBitPos);
        }
        return skippedAllNChars;
    }

    @Override
    public boolean lookingAt(Matcher matcher, FormatInfo finfo) {
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        if (!aligned) {
            return false;
        }
        int regexMatchBufferLimit = finfo.tunable().initialRegexMatchLimitInCharacters();
        CharBuffer regexMatchBuffer = finfo.regexMatchBuffer();
        LongBuffer regexMatchBitPositionBuffer = finfo.regexMatchBitPositionBuffer();
        regexMatchBuffer.position(0);
        regexMatchBuffer.limit(0);
        regexMatchBitPositionBuffer.position(0);
        regexMatchBitPositionBuffer.limit(0);
        long startingBitPos = this.bitPos0b();
        boolean keepMatching = true;
        boolean isMatch = false;
        while (keepMatching) {
            regexMatchBuffer.position(regexMatchBuffer.limit());
            regexMatchBuffer.limit(regexMatchBufferLimit);
            regexMatchBitPositionBuffer.position(regexMatchBitPositionBuffer.limit());
            regexMatchBitPositionBuffer.limit(regexMatchBufferLimit);
            int numDecoded = finfo.decoder().decode(this, finfo, regexMatchBuffer, regexMatchBitPositionBuffer);
            boolean potentiallyMoreData = regexMatchBuffer.position() == regexMatchBuffer.limit();
            regexMatchBuffer.flip();
            regexMatchBitPositionBuffer.flip();
            if (numDecoded > 0) {
                matcher.reset(regexMatchBuffer);
                isMatch = matcher.lookingAt();
                boolean hitEnd = matcher.hitEnd();
                boolean requireEnd = matcher.requireEnd();
                if (potentiallyMoreData && (hitEnd || isMatch && requireEnd)) {
                    if (regexMatchBufferLimit == regexMatchBuffer.capacity()) {
                        keepMatching = false;
                        continue;
                    }
                    regexMatchBufferLimit = Math.min(regexMatchBufferLimit * 2, regexMatchBuffer.capacity());
                    continue;
                }
                keepMatching = false;
                continue;
            }
            keepMatching = false;
        }
        if (isMatch && matcher.end() != 0) {
            long endingBitPos = regexMatchBitPositionBuffer.get(matcher.end() - 1);
            this.setBitPos0b(endingBitPos);
        } else {
            this.setBitPos0b(startingBitPos);
        }
        return isMatch;
    }

    private InputSourceDataInputStreamCharIterator charIterator() {
        return this.charIterator;
    }

    @Override
    public DataInputStream.CharIterator asIteratorChar() {
        InputSourceDataInputStreamCharIterator ci = this.charIterator();
        ci.reset();
        return ci;
    }

    @Override
    public void setDebugging(boolean setting) {
        DataInputStreamImplMixin.setDebugging$(this, setting);
        this.inputSource().setDebugging(setting);
    }

    @Override
    public ByteBuffer pastData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.usageError("Usage error: nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        int bytesToRead = (int)Math.min(savedBytePosition, (long)nBytesRequested);
        long newBytePosition = savedBytePosition - (long)bytesToRead;
        this.inputSource().position(newBytePosition);
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    @Override
    public ByteBuffer futureData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.usageError("Usage error: nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        boolean available = this.inputSource().areBytesAvailable(nBytesRequested);
        int bytesToRead = available ? nBytesRequested : (int)this.inputSource().knownBytesAvailable();
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    private static final byte calcNewByte$1(long curByte, long nxtByte, int curBitMask$1, int nxtBitMask$1, boolean isMSBF$1, int curShift$1, int nxtShift$1) {
        long curBits = curByte & (long)curBitMask$1;
        long nxtBits = nxtByte & (long)nxtBitMask$1;
        long newByte = isMSBF$1 ? curBits << curShift$1 | nxtBits >> nxtShift$1 : curBits >> curShift$1 | nxtBits << nxtShift$1;
        return Bits$.MODULE$.asSignedByte(newByte);
    }

    private final long buildLongFromArray$1(int numBytes$1) {
        long l = Bits$.MODULE$.asUnsignedByte(this.longArray()[0]);
        for (int i = 1; i < numBytes$1; ++i) {
            l = l << 8 | (long)Bits$.MODULE$.asUnsignedByte(this.longArray()[i]);
        }
        return l;
    }

    public static final /* synthetic */ Object $anonfun$getSomeString$1(InputSourceDataInputStream $this, long nChars$1, FormatInfo finfo$1, long startingBitPos$1, LocalBufferMixin.LocalCharBuffer lcb) {
        LongBuffer x$4;
        CharBuffer x$3;
        FormatInfo x$2;
        InputSourceDataInputStream x$1;
        CharBuffer cb = (CharBuffer)lcb.getBuf(nChars$1);
        BitsCharsetDecoder qual$1 = finfo$1.decoder();
        int numDecoded = qual$1.decode(x$1 = $this, x$2 = finfo$1, x$3 = cb, x$4 = qual$1.decode$default$4());
        if (numDecoded > 0) {
            return Maybe$.MODULE$.apply((Object)cb.flip().toString());
        }
        $this.setBitPos0b(startingBitPos$1);
        return Maybe$.MODULE$.Nope();
    }

    public InputSourceDataInputStream(InputSource inputSource) {
        this.inputSource = inputSource;
        DataInputStream.$init$(this);
        DataStreamCommonImplMixin.$init$(this);
        LocalBufferMixin.$init$(this);
        DataInputStreamImplMixin.$init$(this);
        this.cst = new MarkState();
        this.markStack = new MStackOf();
        this.markPool = new MarkPool();
        this.longArray = new byte[8];
        this.charIterator = new InputSourceDataInputStreamCharIterator(this);
    }
}

