/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.memory.Memory;

class IntMemoryPairIterator
implements PairIterator {
    final Memory mem;
    final long offsetBytes;
    final int lengthPairs;
    final int slotMask;
    int index;
    int pair;

    IntMemoryPairIterator(Memory mem, long offsetBytes, int lengthPairs, int lgConfigK) {
        this.mem = mem;
        this.offsetBytes = offsetBytes;
        this.lengthPairs = lengthPairs;
        this.slotMask = (1 << lgConfigK) - 1;
        this.index = -1;
    }

    IntMemoryPairIterator(byte[] byteArr, long offsetBytes, int lengthPairs, int lgConfigK) {
        this(Memory.wrap((byte[])byteArr), offsetBytes, lengthPairs, lgConfigK);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getKey() {
        return HllUtil.getLow26(this.pair);
    }

    @Override
    public int getPair() {
        return this.pair;
    }

    @Override
    public int getSlot() {
        return this.getKey() & this.slotMask;
    }

    @Override
    public int getValue() {
        return HllUtil.getValue(this.pair);
    }

    @Override
    public boolean nextAll() {
        if (++this.index < this.lengthPairs) {
            this.pair = this.pair();
            return true;
        }
        return false;
    }

    @Override
    public boolean nextValid() {
        while (++this.index < this.lengthPairs) {
            int pair = this.pair();
            if (pair == 0) continue;
            this.pair = pair;
            return true;
        }
        return false;
    }

    int pair() {
        return this.mem.getInt(this.offsetBytes + (long)(this.index << 2));
    }
}

