/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapHashIterator;

final class EmptyCompactSketch
extends CompactSketch {
    private static final long EMPTY_SKETCH_MASK = 0xEBFFFFFFFFFFL;
    private static final long EMPTY_SKETCH_TEST = 10995116475137L;
    static final byte[] EMPTY_COMPACT_SKETCH_ARR = new byte[]{1, 3, 3, 0, 0, 30, 0, 0};
    private static final EmptyCompactSketch EMPTY_COMPACT_SKETCH = new EmptyCompactSketch();

    private EmptyCompactSketch() {
    }

    static EmptyCompactSketch getInstance() {
        return EMPTY_COMPACT_SKETCH;
    }

    static EmptyCompactSketch getInstance(Memory srcMem) {
        long pre0 = srcMem.getLong(0L);
        if (EmptyCompactSketch.testCandidatePre0(pre0)) {
            return EMPTY_COMPACT_SKETCH;
        }
        long maskedPre0 = pre0 & 0xEBFFFFFFFFFFL;
        throw new SketchesArgumentException("Input Memory does not match required Preamble. Memory Pre0: " + maskedPre0 + ", required Pre0: " + 0xEBFFFFFFFFFFL);
    }

    static boolean testCandidatePre0(long candidate) {
        return (candidate & 0xEBFFFFFFFFFFL) == 10995116475137L;
    }

    @Override
    public int getCurrentBytes(boolean compact) {
        return 8;
    }

    @Override
    public HashIterator iterator() {
        return new HeapHashIterator(new long[0], 0, Long.MAX_VALUE);
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return 0;
    }

    @Override
    public long getThetaLong() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean hasMemory() {
        return false;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public byte[] toByteArray() {
        return EMPTY_COMPACT_SKETCH_ARR;
    }

    @Override
    long[] getCache() {
        return new long[0];
    }

    @Override
    int getCurrentPreambleLongs(boolean compact) {
        return 1;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    short getSeedHash() {
        return 0;
    }
}

