/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.nio.ByteOrder;
import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.DirectArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.Util;

final class DirectArrayOfDoublesCompactSketch
extends ArrayOfDoublesCompactSketch {
    private Memory mem_;

    DirectArrayOfDoublesCompactSketch(ArrayOfDoublesUpdatableSketch sketch, WritableMemory dstMem) {
        this(sketch, sketch.getThetaLong(), dstMem);
    }

    DirectArrayOfDoublesCompactSketch(ArrayOfDoublesUpdatableSketch sketch, long theta, WritableMemory dstMem) {
        super(sketch.getNumValues());
        DirectArrayOfDoublesCompactSketch.checkIfEnoughMemory((Memory)dstMem, sketch.getRetainedEntries(), sketch.getNumValues());
        this.mem_ = dstMem;
        dstMem.putByte(0L, (byte)1);
        dstMem.putByte(1L, (byte)1);
        dstMem.putByte(2L, (byte)Family.TUPLE.getID());
        dstMem.putByte(3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch.ordinal());
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        this.isEmpty_ = sketch.isEmpty();
        int count = sketch.getRetainedEntries();
        dstMem.putByte(4L, (byte)((isBigEndian ? 1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isEmpty_ ? 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() : 0) | (count > 0 ? 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal() : 0)));
        dstMem.putByte(5L, (byte)this.numValues_);
        dstMem.putShort(6L, Util.computeSeedHash(sketch.getSeed()));
        this.theta_ = Math.min(sketch.getThetaLong(), theta);
        dstMem.putLong(8L, this.theta_);
        if (count > 0) {
            int keyOffset = 24;
            int valuesOffset = keyOffset + 8 * sketch.getRetainedEntries();
            ArrayOfDoublesSketchIterator it = sketch.iterator();
            int actualCount = 0;
            while (it.next()) {
                if (it.getKey() >= this.theta_) continue;
                dstMem.putLong((long)keyOffset, it.getKey());
                dstMem.putDoubleArray((long)valuesOffset, it.getValues(), 0, this.numValues_);
                keyOffset += 8;
                valuesOffset += 8 * this.numValues_;
                ++actualCount;
            }
            dstMem.putInt(16L, actualCount);
        }
    }

    DirectArrayOfDoublesCompactSketch(long[] keys, double[] values, long theta, boolean isEmpty, int numValues, short seedHash, WritableMemory dstMem) {
        super(numValues);
        DirectArrayOfDoublesCompactSketch.checkIfEnoughMemory((Memory)dstMem, values.length, numValues);
        this.mem_ = dstMem;
        dstMem.putByte(0L, (byte)1);
        dstMem.putByte(1L, (byte)1);
        dstMem.putByte(2L, (byte)Family.TUPLE.getID());
        dstMem.putByte(3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch.ordinal());
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        this.isEmpty_ = isEmpty;
        int count = keys.length;
        dstMem.putByte(4L, (byte)((isBigEndian ? 1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isEmpty_ ? 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() : 0) | (count > 0 ? 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal() : 0)));
        dstMem.putByte(5L, (byte)this.numValues_);
        dstMem.putShort(6L, seedHash);
        this.theta_ = theta;
        dstMem.putLong(8L, this.theta_);
        if (count > 0) {
            dstMem.putInt(16L, count);
            dstMem.putLongArray(24L, keys, 0, count);
            dstMem.putDoubleArray(24L + 8L * (long)count, values, 0, values.length);
        }
    }

    DirectArrayOfDoublesCompactSketch(Memory mem) {
        this(mem, 9001L);
    }

    DirectArrayOfDoublesCompactSketch(Memory mem, long seed) {
        super(mem.getByte(5L));
        boolean isBigEndian;
        this.mem_ = mem;
        SerializerDeserializer.validateFamily(mem.getByte(2L), mem.getByte(0L));
        SerializerDeserializer.validateType(this.mem_.getByte(3L), SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch);
        byte version = this.mem_.getByte(1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        boolean bl = isBigEndian = (mem.getByte(4L) & 1 << ArrayOfDoublesSketch.Flags.IS_BIG_ENDIAN.ordinal()) != 0;
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Byte order mismatch");
        }
        Util.checkSeedHashes(mem.getShort(6L), Util.computeSeedHash(seed));
        this.isEmpty_ = (this.mem_.getByte(4L) & 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()) != 0;
        this.theta_ = this.mem_.getLong(8L);
    }

    @Override
    public int getRetainedEntries() {
        boolean hasEntries = (this.mem_.getByte(4L) & 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()) != 0;
        return hasEntries ? this.mem_.getInt(16L) : 0;
    }

    @Override
    public double[][] getValues() {
        int count = this.getRetainedEntries();
        double[][] values = new double[count][];
        if (count > 0) {
            int valuesOffset = 24 + 8 * count;
            for (int i = 0; i < count; ++i) {
                double[] array = new double[this.numValues_];
                this.mem_.getDoubleArray((long)valuesOffset, array, 0, this.numValues_);
                values[i] = array;
                valuesOffset += 8 * this.numValues_;
            }
        }
        return values;
    }

    @Override
    public byte[] toByteArray() {
        int count = this.getRetainedEntries();
        int sizeBytes = 16;
        if (count > 0) {
            sizeBytes = 24 + 8 * count + 8 * count * this.numValues_;
        }
        byte[] byteArray = new byte[sizeBytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        this.mem_.copyTo(0L, mem, 0L, (long)sizeBytes);
        return byteArray;
    }

    @Override
    public ArrayOfDoublesSketchIterator iterator() {
        return new DirectArrayOfDoublesSketchIterator(this.mem_, 24, this.getRetainedEntries(), this.numValues_);
    }

    @Override
    short getSeedHash() {
        return this.mem_.getShort(6L);
    }

    private static void checkIfEnoughMemory(Memory mem, int numEntries, int numValues) {
        int sizeNeeded = 24 + (8 + 8 * numValues) * numEntries;
        if ((long)sizeNeeded > mem.getCapacity()) {
            throw new SketchesArgumentException("Not enough memory: need " + sizeNeeded + " bytes, got " + mem.getCapacity() + " bytes");
        }
    }
}

