/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.DirectArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.DirectArrayOfDoublesQuickSelectSketch;
import org.apache.datasketches.tuple.HeapArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.HeapArrayOfDoublesQuickSelectSketch;
import org.apache.datasketches.tuple.Util;

public abstract class ArrayOfDoublesUpdatableSketch
extends ArrayOfDoublesSketch {
    final long seed_;

    ArrayOfDoublesUpdatableSketch(int numValues, long seed) {
        super(numValues);
        this.seed_ = seed;
    }

    public static ArrayOfDoublesUpdatableSketch heapify(Memory mem) {
        return ArrayOfDoublesUpdatableSketch.heapify(mem, 9001L);
    }

    public static ArrayOfDoublesUpdatableSketch heapify(Memory mem, long seed) {
        return new HeapArrayOfDoublesQuickSelectSketch(mem, seed);
    }

    public static ArrayOfDoublesUpdatableSketch wrap(WritableMemory mem) {
        return ArrayOfDoublesUpdatableSketch.wrap(mem, 9001L);
    }

    public static ArrayOfDoublesUpdatableSketch wrap(WritableMemory mem, long seed) {
        return new DirectArrayOfDoublesQuickSelectSketch(mem, seed);
    }

    public void update(long key, double[] values) {
        this.update(new long[]{key}, values);
    }

    public void update(double key, double[] values) {
        this.update(Util.doubleToLongArray(key), values);
    }

    public void update(String key, double[] values) {
        this.update(Util.stringToByteArray(key), values);
    }

    public void update(byte[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public void update(int[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public void update(long[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public abstract int getNominalEntries();

    public abstract ResizeFactor getResizeFactor();

    public abstract float getSamplingProbability();

    public abstract void trim();

    public abstract void reset();

    public ArrayOfDoublesCompactSketch compact() {
        return this.compact(null);
    }

    public ArrayOfDoublesCompactSketch compact(WritableMemory dstMem) {
        if (dstMem == null) {
            return new HeapArrayOfDoublesCompactSketch(this);
        }
        return new DirectArrayOfDoublesCompactSketch(this, dstMem);
    }

    abstract int getCurrentCapacity();

    long getSeed() {
        return this.seed_;
    }

    @Override
    short getSeedHash() {
        return Util.computeSeedHash(this.seed_);
    }

    abstract void insertOrIgnore(long var1, double[] var3);
}

