/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.cdise.openejb;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.apache.openejb.core.LocalInitialContext;
import org.apache.openejb.core.LocalInitialContextFactory;
import org.apache.webbeans.config.WebBeansContext;

public class OpenEjbContainerControl
implements CdiContainer {
    private static final Properties PROPERTIES = new Properties();
    private ContextControl ctxCtrl = null;
    private Bean<ContextControl> ctxCtrlBean = null;
    private CreationalContext<ContextControl> ctxCtrlCreationalContext = null;
    private Context context = null;
    private BeanManager beanManager;

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public synchronized void boot() {
        this.boot(null);
    }

    public synchronized void boot(Map<?, ?> properties) {
        if (this.context == null) {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)PROPERTIES);
            if (properties != null) {
                p.putAll(properties);
            }
            try {
                this.context = new InitialContext(p);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            this.beanManager = WebBeansContext.currentInstance().getBeanManagerImpl();
        }
    }

    public synchronized void shutdown() {
        if (this.ctxCtrl != null) {
            this.ctxCtrlBean.destroy((Object)this.ctxCtrl, this.ctxCtrlCreationalContext);
        }
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.context = null;
        }
        this.ctxCtrl = null;
        this.ctxCtrlBean = null;
        this.ctxCtrlCreationalContext = null;
        this.beanManager = null;
    }

    public synchronized ContextControl getContextControl() {
        if (this.ctxCtrl == null) {
            Set beans = this.getBeanManager().getBeans(ContextControl.class, new Annotation[0]);
            this.ctxCtrlBean = this.getBeanManager().resolve(beans);
            this.ctxCtrlCreationalContext = this.getBeanManager().createCreationalContext(this.ctxCtrlBean);
            this.ctxCtrl = (ContextControl)this.getBeanManager().getReference(this.ctxCtrlBean, ContextControl.class, this.ctxCtrlCreationalContext);
        }
        return this.ctxCtrl;
    }

    static {
        PROPERTIES.setProperty("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
        PROPERTIES.setProperty("openejb.embedded.initialcontext.close", LocalInitialContext.Close.DESTROY.name());
        try {
            OpenEjbContainerControl.class.getClassLoader().loadClass("org.apache.openejb.server.ServiceManager");
            PROPERTIES.setProperty("openejb.embedded.remotable", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

