/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.security.impl.authentication;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.impl.exclude.extension.ExcludeExtension;
import org.apache.deltaspike.security.api.Identity;
import org.apache.deltaspike.security.api.authentication.UnexpectedCredentialException;
import org.apache.deltaspike.security.api.credential.LoginCredential;
import org.apache.deltaspike.test.security.impl.authentication.FailedLoginFailedObserver;
import org.apache.deltaspike.test.security.impl.authentication.ShopClient;
import org.apache.deltaspike.test.security.impl.authentication.TestAuthenticator;
import org.apache.deltaspike.test.security.impl.authentication.TestInquiryStorage;
import org.apache.deltaspike.test.util.ArchiveUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class LoginLogoutTest {
    @Inject
    private TestAuthenticator authenticator;
    @Inject
    private TestInquiryStorage testInquiryStorage;
    @Inject
    private ShopClient shopClient;
    @Inject
    private Identity identity;
    @Inject
    private FailedLoginFailedObserver failedLoginFailedObserver;

    @Deployment
    public static WebArchive deploy() {
        new BeanManagerProvider(){

            public void setTestMode() {
                super.setTestMode();
            }
        }.setTestMode();
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"loginLogoutTest.jar")).addPackage("org.apache.deltaspike.test.security.impl.authentication")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndSecurityArchive())).addAsLibraries(new Archive[]{testJar})).addAsServiceProvider(Extension.class, new Class[]{ExcludeExtension.class})).addAsWebInfResource(ArchiveUtils.getBeansXml(), "beans.xml");
    }

    @Test
    public void loginAndLogout() {
        String userName = "spike";
        String password = "apache";
        this.authenticator.register("spike", "apache");
        this.shopClient.login("spike", "apache");
        Assert.assertTrue((boolean)this.identity.isLoggedIn());
        Assert.assertEquals((Object)"spike", (Object)this.identity.getUser().getId());
        Assert.assertNotNull((Object)this.shopClient.requestNewProduct("Security module for DeltaSpike"));
        this.shopClient.logout();
        Assert.assertFalse((boolean)this.identity.isLoggedIn());
        Assert.assertNotNull((Object)this.shopClient.requestNewProduct("I18n module for DeltaSpike"));
        Assert.assertEquals((long)1L, (long)this.testInquiryStorage.getUserInquiries().size());
        Assert.assertEquals((Object)"spike", (Object)this.testInquiryStorage.getUserInquiries().iterator().next().getUserName());
        Assert.assertEquals((long)1L, (long)this.testInquiryStorage.getAnonymInquiries().size());
        Assert.assertFalse((boolean)this.testInquiryStorage.getUserInquiries().iterator().next().getInquiry().equals(this.testInquiryStorage.getAnonymInquiries().iterator()));
    }

    @Test
    public void failedLogin() {
        String userName = "spike";
        String password = "apache";
        this.authenticator.register("spike", "apache");
        this.shopClient.login("spike", "123");
        Assert.assertFalse((boolean)this.identity.isLoggedIn());
    }

    @Test
    public void failedForcedReLogin() {
        String userName = "spike";
        String password = "apache";
        this.authenticator.register("spike", "apache");
        this.shopClient.login("spike", "apache");
        Assert.assertTrue((boolean)this.identity.isLoggedIn());
        Assert.assertEquals((Object)"spike", (Object)this.identity.getUser().getId());
        ((LoginCredential)BeanProvider.getContextualReference(LoginCredential.class, (Annotation[])new Annotation[0])).invalidate();
        try {
            this.shopClient.login("xyz", "123");
        }
        catch (UnexpectedCredentialException e) {
            Assert.assertTrue((boolean)(this.failedLoginFailedObserver.getObservedException() instanceof UnexpectedCredentialException));
            Assert.assertTrue((boolean)this.identity.isLoggedIn());
            return;
        }
        Assert.fail();
    }
}

