/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.security.impl.authorization.securityparameterbinding;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.Extension;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.impl.exclude.extension.ExcludeExtension;
import org.apache.deltaspike.security.api.authorization.AccessDeniedException;
import org.apache.deltaspike.test.security.impl.authorization.securityparameterbinding.MockObject;
import org.apache.deltaspike.test.security.impl.authorization.securityparameterbinding.SecuredBean1;
import org.apache.deltaspike.test.security.impl.authorization.securityparameterbinding.SecuredBean2;
import org.apache.deltaspike.test.util.ArchiveUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SecurityParameterBindingTest {
    @Deployment
    public static WebArchive deploy() {
        new BeanManagerProvider(){

            public void setTestMode() {
                super.setTestMode();
            }
        }.setTestMode();
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(SecurityParameterBindingTest.class.getSimpleName() + ".jar"))).addPackage(SecurityParameterBindingTest.class.getPackage().getName())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibraries((Archive[])ArchiveUtils.getDeltaSpikeCoreAndSecurityArchive())).addAsLibraries(new Archive[]{testJar})).addAsServiceProvider(Extension.class, new Class[]{ExcludeExtension.class})).addAsWebInfResource(ArchiveUtils.getBeansXml(), "beans.xml");
    }

    @Test(expected=IllegalStateException.class)
    public void simpleInterceptorThrowsExceptionWhenImproperlyAnnotated() {
        SecuredBean1 testBean = (SecuredBean1)BeanProvider.getContextualReference(SecuredBean1.class, (boolean)false, (Annotation[])new Annotation[0]);
        testBean.getResult(new MockObject(true));
    }

    @Test(expected=AccessDeniedException.class)
    public void simpleInterceptorDeniesTest() {
        SecuredBean1 testBean = (SecuredBean1)BeanProvider.getContextualReference(SecuredBean1.class, (boolean)false, (Annotation[])new Annotation[0]);
        testBean.getBlockedResult(new MockObject(false));
    }

    @Test
    public void simpleInterceptorAllowsTest() {
        SecuredBean1 testBean = (SecuredBean1)BeanProvider.getContextualReference(SecuredBean1.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertTrue((boolean)testBean.getBlockedResult(new MockObject(true)));
    }

    @Test
    public void simpleInterceptorIgnoresUnsecuredMethods() {
        SecuredBean2 testBean = (SecuredBean2)BeanProvider.getContextualReference(SecuredBean2.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertTrue((boolean)testBean.getResult(new MockObject(true)));
    }

    @Test(expected=AccessDeniedException.class)
    public void simpleInterceptorTestOnMethodsDenies() {
        SecuredBean2 testBean = (SecuredBean2)BeanProvider.getContextualReference(SecuredBean2.class, (boolean)false, (Annotation[])new Annotation[0]);
        testBean.getBlockedResult(new MockObject(false));
    }

    @Test
    public void simpleInterceptorTestOnMethodsAllows() {
        SecuredBean2 testBean = (SecuredBean2)BeanProvider.getContextualReference(SecuredBean2.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertTrue((boolean)testBean.getBlockedResult(new MockObject(true)));
    }
}

