/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.impl.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.deltaspike.security.api.authorization.SecurityDefinitionException;
import org.apache.deltaspike.security.impl.extension.Authorizer;
import org.apache.deltaspike.security.impl.util.SecurityUtils;

class SecurityMetaDataStorage {
    private Set<Authorizer> authorizers = new HashSet<Authorizer>();
    private Set<AnnotatedType<?>> securedTypes = new HashSet();
    private Map<Class<?>, Map<Method, Set<Authorizer>>> methodAuthorizers = new HashMap();

    SecurityMetaDataStorage() {
    }

    void addAuthorizer(Authorizer authorizer) {
        this.authorizers.add(authorizer);
    }

    void addSecuredType(AnnotatedType<?> annotatedType) {
        this.securedTypes.add(annotatedType);
    }

    Set<AnnotatedType<?>> getSecuredTypes() {
        return this.securedTypes;
    }

    void resetSecuredTypes() {
        this.securedTypes = null;
    }

    Set<Authorizer> getAuthorizers(Class<?> targetClass, Method targetMethod) {
        if (!this.isMethodMetaDataAvailable(targetClass, targetMethod)) {
            this.registerSecuredMethod(targetClass, targetMethod);
        }
        return this.getMethodAuthorizers(targetClass, targetMethod);
    }

    synchronized void registerSecuredMethod(Class<?> targetClass, Method targetMethod) {
        this.ensureInitializedAuthorizersForClass(targetClass);
        if (!this.containsMethodAuthorizers(targetClass, targetMethod)) {
            HashSet<Annotation> bindings = new HashSet<Annotation>();
            Class<?> cls = targetClass;
            while (!cls.equals(Object.class)) {
                for (Annotation annotation : cls.getAnnotations()) {
                    if (!SecurityUtils.isMetaAnnotatedWithSecurityBindingType(annotation)) continue;
                    bindings.add(annotation);
                }
                cls = cls.getSuperclass();
            }
            for (Annotation annotation : targetMethod.getAnnotations()) {
                if (!SecurityUtils.isMetaAnnotatedWithSecurityBindingType(annotation)) continue;
                bindings.add(annotation);
            }
            HashSet<Authorizer> authorizerStack = new HashSet<Authorizer>();
            for (Annotation binding : bindings) {
                boolean found = false;
                for (Authorizer authorizer : this.authorizers) {
                    if (!authorizer.matchesBinding(binding)) continue;
                    if (found) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Matching authorizer methods found: [");
                        sb.append(authorizer.getBoundAuthorizerMethod().getDeclaringClass().getName());
                        sb.append(".");
                        sb.append(authorizer.getBoundAuthorizerMethod().getName());
                        sb.append("]");
                        for (Authorizer a : authorizerStack) {
                            if (!a.matchesBinding(binding)) continue;
                            sb.append(", [");
                            sb.append(a.getBoundAuthorizerMethod().getDeclaringClass().getName());
                            sb.append(".");
                            sb.append(a.getBoundAuthorizerMethod().getName());
                            sb.append("]");
                        }
                        throw new SecurityDefinitionException("Ambiguous authorizers found for security binding type [@" + binding.annotationType().getName() + "] on method [" + targetMethod.getDeclaringClass().getName() + "." + targetMethod.getName() + "]. " + sb.toString());
                    }
                    authorizerStack.add(authorizer);
                    found = true;
                }
                if (found) continue;
                throw new SecurityDefinitionException("No matching authorizer found for security binding type [@" + binding.annotationType().getName() + "] on method [" + targetMethod.getDeclaringClass().getName() + "." + targetMethod.getName() + "].");
            }
            this.addMethodAuthorizer(targetClass, targetMethod, authorizerStack);
        }
    }

    Set<Authorizer> getAuthorizers() {
        return this.authorizers;
    }

    private boolean containsMethodAuthorizers(Class<?> targetClass, Method targetMethod) {
        Map<Method, Set<Authorizer>> resultForClass = this.methodAuthorizers.get(targetClass);
        return resultForClass.containsKey(targetMethod);
    }

    private void ensureInitializedAuthorizersForClass(Class<?> targetClass) {
        Map<Method, Set<Authorizer>> resultForClass = this.methodAuthorizers.get(targetClass);
        if (resultForClass == null) {
            this.methodAuthorizers.put(targetClass, new HashMap());
        }
    }

    private boolean isMethodMetaDataAvailable(Class<?> targetClass, Method targetMethod) {
        Map<Method, Set<Authorizer>> result = this.methodAuthorizers.get(targetClass);
        return result != null && result.containsKey(targetMethod);
    }

    private void addMethodAuthorizer(Class<?> targetClass, Method targetMethod, Set<Authorizer> authorizersToAdd) {
        Set<Authorizer> authorizersForMethod;
        Map<Method, Set<Authorizer>> authorizerMapping = this.methodAuthorizers.get(targetClass);
        if (authorizerMapping == null) {
            authorizerMapping = new HashMap<Method, Set<Authorizer>>();
            this.methodAuthorizers.put(targetClass, authorizerMapping);
        }
        if ((authorizersForMethod = authorizerMapping.get(targetMethod)) == null) {
            authorizersForMethod = new HashSet<Authorizer>();
            authorizerMapping.put(targetMethod, authorizersForMethod);
        }
        authorizersForMethod.addAll(authorizersToAdd);
    }

    private Set<Authorizer> getMethodAuthorizers(Class<?> targetClass, Method targetMethod) {
        Map<Method, Set<Authorizer>> resultForClass = this.methodAuthorizers.get(targetClass);
        if (resultForClass == null) {
            throw new IllegalStateException("no meta-data available for: " + targetClass.getName() + targetMethod.getName());
        }
        return resultForClass.get(targetMethod);
    }
}

