/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.impl.extension;

import java.lang.reflect.Method;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.security.impl.extension.Authorizer;
import org.apache.deltaspike.security.impl.extension.SecurityExtension;
import org.apache.deltaspike.security.impl.extension.SecurityMetaDataStorage;
import org.apache.deltaspike.security.spi.authorization.SecurityStrategy;

@Dependent
public class DefaultSecurityStrategy
implements SecurityStrategy {
    private static final long serialVersionUID = 7992336651801599079L;
    @Inject
    private BeanManager beanManager;
    @Inject
    private SecurityExtension securityExtension;

    public Object execute(InvocationContext invocationContext) throws Exception {
        Method method = invocationContext.getMethod();
        SecurityMetaDataStorage metaDataStorage = this.securityExtension.getMetaDataStorage();
        for (Authorizer authorizer : metaDataStorage.getAuthorizers(invocationContext.getTarget().getClass(), method)) {
            if (!authorizer.isBeforeMethodInvocationAuthorizer()) continue;
            authorizer.authorize(invocationContext, null, this.beanManager);
        }
        Object result = invocationContext.proceed();
        for (Authorizer authorizer : metaDataStorage.getAuthorizers(invocationContext.getTarget().getClass(), method)) {
            if (!authorizer.isAfterMethodInvocationAuthorizer()) continue;
            authorizer.authorize(invocationContext, result, this.beanManager);
        }
        return result;
    }
}

