/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.impl.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.security.api.authorization.SecurityBindingType;
import org.apache.deltaspike.security.api.authorization.SecurityParameterBinding;

@Typed
public abstract class SecurityUtils {
    private SecurityUtils() {
    }

    public static Set<Annotation> getSecurityBindingTypes(Class<?> targetClass, Method targetMethod) {
        HashSet<Annotation> securityBindingTypes = new HashSet<Annotation>();
        for (Class<?> cls = targetClass; cls != null && !cls.equals(Object.class); cls = cls.getSuperclass()) {
            for (Annotation annotation : cls.getAnnotations()) {
                if (!SecurityUtils.isMetaAnnotatedWithSecurityBindingType(annotation)) continue;
                securityBindingTypes.add(annotation);
            }
        }
        for (Annotation annotation : targetMethod.getAnnotations()) {
            if (!SecurityUtils.isMetaAnnotatedWithSecurityBindingType(annotation)) continue;
            securityBindingTypes.add(annotation);
        }
        return securityBindingTypes;
    }

    public static boolean isMetaAnnotatedWithSecurityBindingType(Annotation annotation) {
        if (annotation.annotationType().isAnnotationPresent(SecurityBindingType.class)) {
            return true;
        }
        List<Annotation> result = SecurityUtils.getAllAnnotations(annotation.annotationType().getAnnotations());
        for (Annotation foundAnnotation : result) {
            if (!SecurityBindingType.class.isAssignableFrom(foundAnnotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static Annotation resolveSecurityBindingType(Annotation annotation) {
        List<Annotation> result = SecurityUtils.getAllAnnotations(annotation.annotationType().getAnnotations());
        for (Annotation foundAnnotation : result) {
            if (!foundAnnotation.annotationType().isAnnotationPresent(SecurityBindingType.class)) continue;
            return foundAnnotation;
        }
        throw new IllegalStateException(annotation.annotationType().getName() + " is a " + Stereotype.class.getName() + " but it isn't annotated with " + SecurityBindingType.class.getName());
    }

    public static boolean isMetaAnnotatedWithSecurityParameterBinding(Annotation annotation) {
        if (annotation.annotationType().isAnnotationPresent(SecurityParameterBinding.class)) {
            return true;
        }
        List<Annotation> result = SecurityUtils.getAllAnnotations(annotation.annotationType().getAnnotations());
        for (Annotation foundAnnotation : result) {
            if (!SecurityParameterBinding.class.isAssignableFrom(foundAnnotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static List<Annotation> getAllAnnotations(Annotation[] annotations) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            String annotationName = annotation.annotationType().getName();
            if (annotationName.startsWith("java.") || annotationName.startsWith("javax.")) continue;
            result.add(annotation);
            result.addAll(SecurityUtils.getAllAnnotations(annotation.annotationType().getAnnotations()));
        }
        return result;
    }
}

