/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.security.impl.authorization.secured;

import java.lang.annotation.Annotation;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.security.api.authorization.AccessDeniedException;
import org.apache.deltaspike.test.security.impl.authorization.secured.SecuredBean1;
import org.apache.deltaspike.test.security.impl.authorization.secured.SecuredBean2;
import org.apache.deltaspike.test.security.impl.authorization.secured.SecuredBean3;
import org.apache.deltaspike.test.security.impl.authorization.secured.SecuredBean4;
import org.apache.deltaspike.test.security.impl.authorization.secured.SecuredBean5;
import org.apache.deltaspike.test.security.impl.authorization.secured.TestAccessDecisionVoter1;
import org.apache.deltaspike.test.security.impl.authorization.secured.TestAccessDecisionVoter2;
import org.junit.Assert;
import org.junit.Test;

public abstract class SecuredAnnotationTest {
    @Test
    public void simpleInterceptorTest() {
        SecuredBean1 testBean = (SecuredBean1)BeanProvider.getContextualReference(SecuredBean1.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertEquals((Object)"result", (Object)testBean.getResult());
        try {
            testBean.getBlockedResult();
            Assert.fail((String)"AccessDeniedException expect, but was not thrown");
        }
        catch (AccessDeniedException e) {
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected Exception: " + e));
        }
    }

    @Test
    public void interceptorTestWithStereotype() {
        SecuredBean2 testBean = (SecuredBean2)BeanProvider.getContextualReference(SecuredBean2.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertEquals((Object)"result", (Object)testBean.getResult());
        try {
            testBean.getBlockedResult();
            Assert.fail((String)"AccessDeniedException expect, but was not thrown");
        }
        catch (AccessDeniedException e) {
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected Exception: " + e));
        }
    }

    @Test
    public void interceptorTestWithStereotypeWithValue() {
        SecuredBean5 testBean = (SecuredBean5)BeanProvider.getContextualReference(SecuredBean5.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertEquals((Object)"result", (Object)testBean.getResult());
        try {
            testBean.getBlockedResult();
            Assert.fail((String)"AccessDeniedException expect, but was not thrown");
        }
        catch (AccessDeniedException e) {
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected Exception: " + e));
        }
    }

    @Test
    public void simpleInterceptorTestOnMethods() {
        SecuredBean3 testBean = (SecuredBean3)BeanProvider.getContextualReference(SecuredBean3.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertEquals((Object)"result", (Object)testBean.getResult());
        try {
            testBean.getBlockedResult();
            Assert.fail((String)"AccessDeniedException expect, but was not thrown");
        }
        catch (AccessDeniedException e) {
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected Exception: " + e));
        }
    }

    @Test
    public void invocationOfMultipleSecuredStereotypes() {
        SecuredBean4 testBean = (SecuredBean4)BeanProvider.getContextualReference(SecuredBean4.class, (boolean)false, (Annotation[])new Annotation[0]);
        TestAccessDecisionVoter1 voter1 = (TestAccessDecisionVoter1)BeanProvider.getContextualReference(TestAccessDecisionVoter1.class, (boolean)false, (Annotation[])new Annotation[0]);
        TestAccessDecisionVoter2 voter2 = (TestAccessDecisionVoter2)BeanProvider.getContextualReference(TestAccessDecisionVoter2.class, (boolean)false, (Annotation[])new Annotation[0]);
        Assert.assertFalse((boolean)voter1.isCalled());
        Assert.assertFalse((boolean)voter2.isCalled());
        Assert.assertEquals((Object)"result", (Object)testBean.getResult());
        Assert.assertTrue((boolean)voter1.isCalled());
        Assert.assertTrue((boolean)voter2.isCalled());
    }
}

