/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.jdbc.ClientDataSourceInterface;
import org.apache.derby.jdbc.ClientDriver;
import org.apache.derby.shared.common.error.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientBaseDataSourceRoot
implements Serializable,
ClientDataSourceInterface {
    private static final long serialVersionUID = -7660172643035173693L;
    static final boolean SUPPORTS_EUSRIDPWD;
    private int loginTimeout;
    private transient PrintWriter logWriter;
    private String databaseName;
    private String description;
    private String dataSourceName;
    private int portNumber = 1527;
    private String serverName = "localhost";
    public static final int SSL_OFF = 0;
    private static final String SSL_OFF_STR = "off";
    public static final int SSL_BASIC = 1;
    private static final String SSL_BASIC_STR = "basic";
    public static final int SSL_PEER_AUTHENTICATION = 2;
    private static final String SSL_PEER_AUTHENTICATION_STR = "peerAuthentication";
    private String user = "APP";
    private static final short SECMEC_HAS_NOT_EXPLICITLY_SET = 0;
    protected short securityMechanism = 0;
    private boolean retrieveMessageText = true;
    private String traceFile;
    private transient int traceFileSuffixIndex_ = 0;
    private String traceDirectory;
    private boolean traceFileAppend = false;
    private String password;
    private int sslMode;
    private boolean createDatabase;
    private boolean shutdownDatabase;
    protected String connectionAttributes = null;
    protected int traceLevel = -1;

    ClientBaseDataSourceRoot() {
    }

    @Override
    public synchronized void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public static int getSSLModeFromString(String string) throws SqlException {
        if (string != null) {
            if (string.equalsIgnoreCase(SSL_OFF_STR)) {
                return 0;
            }
            if (string.equalsIgnoreCase(SSL_BASIC_STR)) {
                return 1;
            }
            if (string.equalsIgnoreCase(SSL_PEER_AUTHENTICATION_STR)) {
                return 2;
            }
            throw new SqlException(null, new ClientMessageId("XJ05B.C"), (Object)"ssl", (Object)string, "off, basic, peerAuthentication");
        }
        return 0;
    }

    public static int getClientSSLMode(Properties properties) throws SqlException {
        return ClientBaseDataSourceRoot.getSSLModeFromString(properties.getProperty("ssl"));
    }

    public static String getUser(Properties properties) {
        String string = properties.getProperty("user");
        return ClientBaseDataSourceRoot.parseString(string, "APP");
    }

    public static short getSecurityMechanism(Properties properties) {
        short s;
        String string = properties.getProperty("securityMechanism");
        if (string != null) {
            s = Short.parseShort(string);
        } else {
            String string2 = properties.getProperty("password");
            s = ClientBaseDataSourceRoot.getUpgradedSecurityMechanism(string2);
        }
        return s;
    }

    public static short getUpgradedSecurityMechanism(String string) {
        if (string == null) {
            return 4;
        }
        return 3;
    }

    public static boolean getRetrieveMessageText(Properties properties) {
        String string = properties.getProperty("retrieveMessageText");
        return ClientBaseDataSourceRoot.parseBoolean(string, true);
    }

    public static String getTraceFile(Properties properties) {
        return properties.getProperty("traceFile");
    }

    public static String getTraceDirectory(Properties properties) {
        String string = ClientBaseDataSourceRoot.readSystemProperty("derby.client.traceDirectory");
        if (string == null) {
            return properties.getProperty("traceDirectory");
        }
        return string;
    }

    private static String readSystemProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(string);
                }
                catch (SecurityException securityException) {
                    return null;
                }
            }
        });
    }

    public static boolean getTraceFileAppend(Properties properties) {
        String string = properties.getProperty("traceFileAppend");
        return ClientBaseDataSourceRoot.parseBoolean(string, false);
    }

    public static String getPassword(Properties properties) {
        return properties.getProperty("password");
    }

    @Override
    public final synchronized void setPassword(String string) {
        this.password = string;
    }

    @Override
    public final String getPassword() {
        return this.password;
    }

    LogWriter computeDncLogWriterForNewConnection(String string) throws SqlException {
        return ClientBaseDataSourceRoot.computeDncLogWriterForNewConnection(this.logWriter, this.traceDirectory, this.traceFile, this.traceFileAppend, this.traceLevel, string, this.traceFileSuffixIndex_++);
    }

    static LogWriter computeDncLogWriterForNewConnection(PrintWriter printWriter, String string, String string2, boolean bl, int n, String string3, int n2) throws SqlException {
        int n3 = Configuration.traceFileSuffixIndex__++;
        LogWriter logWriter = ClientBaseDataSourceRoot.computeDncLogWriter(printWriter, string, string2, bl, string3, n2, n);
        if (logWriter != null) {
            return logWriter;
        }
        logWriter = ClientBaseDataSourceRoot.computeDncLogWriter(null, Configuration.traceDirectory__, Configuration.traceFile__, Configuration.traceFileAppend__, "_global", n3, Configuration.traceLevel__);
        return logWriter;
    }

    static LogWriter computeDncLogWriter(PrintWriter printWriter, String string, String string2, boolean bl, String string3, int n, int n2) throws SqlException {
        if (n2 == 0) {
            return null;
        }
        PrintWriter printWriter2 = ClientBaseDataSourceRoot.computePrintWriter(printWriter, string, string2, bl, string3, n);
        if (printWriter2 == null) {
            return null;
        }
        NetLogWriter netLogWriter = new NetLogWriter(printWriter2, n2);
        if (printWriter2 != printWriter && (string != null || string2 != null)) {
            netLogWriter.printWriterNeedsToBeClosed_ = true;
        }
        return netLogWriter;
    }

    public static LogWriter computeDncLogWriter(org.apache.derby.client.am.Connection connection, PrintWriter printWriter, String string, String string2, boolean bl, String string3, int n, int n2) throws SqlException {
        if (n2 == 0) {
            return null;
        }
        PrintWriter printWriter2 = ClientBaseDataSourceRoot.computePrintWriter(printWriter, string, string2, bl, string3, n);
        if (printWriter2 == null) {
            return null;
        }
        LogWriter logWriter = connection.agent_.newLogWriter_(printWriter2, n2);
        if (printWriter2 != printWriter && (string != null || string2 != null)) {
            logWriter.printWriterNeedsToBeClosed_ = true;
        }
        return logWriter;
    }

    static PrintWriter computePrintWriter(PrintWriter printWriter, String string, String string2, boolean bl, String string3, int n) throws SqlException {
        if (printWriter != null) {
            return printWriter;
        }
        if (string != null) {
            String string4 = string2 == null ? string + File.separator + string3 + "_" + n : string + File.separator + string2 + string3 + "_" + n;
            return LogWriter.getPrintWriter(string4, true);
        }
        if (string2 != null) {
            return LogWriter.getPrintWriter(string2, bl);
        }
        return null;
    }

    private static boolean parseBoolean(String string, boolean bl) {
        if (string != null) {
            return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        return bl;
    }

    private static String parseString(String string, String string2) {
        if (string != null) {
            return string;
        }
        return string2;
    }

    private static int parseInt(String string, int n) {
        if (string != null) {
            return Integer.parseInt(string);
        }
        return n;
    }

    static Properties tokenizeAttributes(String string, Properties properties) throws SqlException {
        if (string == null) {
            return properties;
        }
        Properties properties2 = properties != null ? (Properties)properties.clone() : new Properties();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n == -1) {
                    throw new SqlException(null, new ClientMessageId("XJ212.S"), string);
                }
                properties2.setProperty(string2.substring(0, n).trim(), string2.substring(n + 1).trim());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SqlException(null, new ClientMessageId("XJ212.S"), (Object)string, (Throwable)noSuchElementException);
        }
        ClientBaseDataSourceRoot.checkBoolean(properties2, "retrieveMessageText");
        return properties2;
    }

    private static void checkBoolean(Properties properties, String string) throws SqlException {
        String[] stringArray = new String[]{"true", "false"};
        ClientBaseDataSourceRoot.checkEnumeration(properties, string, stringArray);
    }

    private static void checkEnumeration(Properties properties, String string, String[] stringArray) throws SqlException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.toUpperCase(Locale.ENGLISH).equals(stringArray[i].toUpperCase(Locale.ENGLISH))) continue;
            return;
        }
        String string3 = "{";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string3 = string3 + "|";
            }
            string3 = string3 + stringArray[i];
        }
        throw new SqlException(null, new ClientMessageId("XJ05B.C"), (Object)string, (Object)string2, string3);
    }

    @Override
    public synchronized void setDatabaseName(String string) {
        this.databaseName = string;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public synchronized void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public synchronized void setDescription(String string) {
        this.description = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized void setPortNumber(int n) {
        this.portNumber = n;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public synchronized void setServerName(String string) {
        this.serverName = string;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public synchronized void setUser(String string) {
        this.user = string;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public synchronized void setRetrieveMessageText(boolean bl) {
        this.retrieveMessageText = bl;
    }

    @Override
    public boolean getRetrieveMessageText() {
        return this.retrieveMessageText;
    }

    @Override
    public synchronized void setSecurityMechanism(short s) {
        this.securityMechanism = s;
    }

    @Override
    public short getSecurityMechanism() {
        return this.getSecurityMechanism(this.getPassword());
    }

    @Override
    public short getSecurityMechanism(String string) {
        if (this.securityMechanism == 0) {
            return ClientBaseDataSourceRoot.getUpgradedSecurityMechanism(string);
        }
        return this.securityMechanism;
    }

    @Override
    public void setSsl(String string) throws SqlException {
        this.sslMode = ClientBaseDataSourceRoot.getSSLModeFromString(string);
    }

    @Override
    public String getSsl() {
        switch (this.sslMode) {
            default: {
                return SSL_OFF_STR;
            }
            case 1: {
                return SSL_BASIC_STR;
            }
            case 2: 
        }
        return SSL_PEER_AUTHENTICATION_STR;
    }

    @Override
    public final void setCreateDatabase(String string) {
        this.createDatabase = string != null && string.equalsIgnoreCase("create");
    }

    @Override
    public final String getCreateDatabase() {
        String string = null;
        if (this.createDatabase) {
            string = "create";
        }
        return string;
    }

    @Override
    public final void setShutdownDatabase(String string) {
        this.shutdownDatabase = string != null && string.equalsIgnoreCase("shutdown");
    }

    @Override
    public final String getShutdownDatabase() {
        String string = null;
        if (this.shutdownDatabase) {
            string = "shutdown";
        }
        return string;
    }

    @Override
    public final void setConnectionAttributes(String string) {
        this.connectionAttributes = string;
    }

    @Override
    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public static int getTraceLevel(Properties properties) {
        String string = ClientBaseDataSourceRoot.readSystemProperty("derby.client.traceLevel");
        if (string == null) {
            string = properties.getProperty("traceLevel");
        }
        return ClientBaseDataSourceRoot.parseInt(string, -1);
    }

    @Override
    public synchronized void setTraceLevel(int n) {
        this.traceLevel = n;
    }

    @Override
    public int getTraceLevel() {
        return this.traceLevel;
    }

    @Override
    public synchronized void setTraceFile(String string) {
        this.traceFile = string;
    }

    @Override
    public String getTraceFile() {
        return this.traceFile;
    }

    @Override
    public synchronized void setTraceDirectory(String string) {
        this.traceDirectory = string;
    }

    @Override
    public String getTraceDirectory() {
        return this.traceDirectory;
    }

    @Override
    public synchronized void setTraceFileAppend(boolean bl) {
        this.traceFileAppend = bl;
    }

    @Override
    public boolean getTraceFileAppend() {
        return this.traceFileAppend;
    }

    public int maxStatementsToPool() {
        return 0;
    }

    void updateDataSourceValues(Properties properties) throws SqlException {
        if (properties == null) {
            return;
        }
        if (properties.containsKey("user")) {
            this.setUser(ClientBaseDataSourceRoot.getUser(properties));
        }
        if (properties.containsKey("securityMechanism")) {
            this.setSecurityMechanism(ClientBaseDataSourceRoot.getSecurityMechanism(properties));
        }
        if (properties.containsKey("traceFile")) {
            this.setTraceFile(ClientBaseDataSourceRoot.getTraceFile(properties));
        }
        if (properties.containsKey("traceDirectory")) {
            this.setTraceDirectory(ClientBaseDataSourceRoot.getTraceDirectory(properties));
        }
        if (properties.containsKey("traceFileAppend")) {
            this.setTraceFileAppend(ClientBaseDataSourceRoot.getTraceFileAppend(properties));
        }
        if (properties.containsKey("retrieveMessageText")) {
            this.setRetrieveMessageText(ClientBaseDataSourceRoot.getRetrieveMessageText(properties));
        }
        if (properties.containsKey("ssl")) {
            this.sslMode = ClientBaseDataSourceRoot.getClientSSLMode(properties);
        }
    }

    protected final void handleConnectionException(LogWriter logWriter, SqlException sqlException) throws SQLException {
        if (sqlException.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ212.S"))) {
            throw new SqlException(logWriter, new ClientMessageId("XJ028.C"), (Object)this.constructUrl(), (Throwable)sqlException).getSQLException();
        }
    }

    private String constructUrl() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("jdbc:derby://");
        stringBuilder.append(this.serverName);
        stringBuilder.append(':');
        stringBuilder.append(this.portNumber);
        stringBuilder.append('/');
        stringBuilder.append(this.databaseName);
        if (this.connectionAttributes != null) {
            stringBuilder.append(';');
            stringBuilder.append(this.connectionAttributes);
        }
        return stringBuilder.toString();
    }

    @Override
    public Connection getConnection() throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(ClientBaseDataSourceRoot.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = this.computeDncLogWriterForNewConnection("_sds");
            return this.getConnectionX(logWriter, this.getUser(), this.getPassword());
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(ClientBaseDataSourceRoot.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = this.computeDncLogWriterForNewConnection("_sds");
            return this.getConnectionX(logWriter, string, string2);
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    private Connection getConnectionX(LogWriter logWriter, String string, String string2) throws SqlException {
        return ClientDriver.getFactory().newNetConnection((LogWriter)((NetLogWriter)logWriter), string, string2, this, -1, false);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), clazz).getSQLException();
        }
    }

    protected final PooledConnection getPooledConnectionMinion() throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(ClientBaseDataSourceRoot.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = this.computeDncLogWriterForNewConnection("_cpds");
            if (logWriter != null) {
                logWriter.traceEntry(this, "getPooledConnection");
            }
            PooledConnection pooledConnection = ClientBaseDataSourceRoot.getPooledConnectionX(logWriter, this, this.getUser(), this.getPassword());
            if (logWriter != null) {
                logWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    protected final PooledConnection getPooledConnectionMinion(String string, String string2) throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(ClientBaseDataSourceRoot.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = this.computeDncLogWriterForNewConnection("_cpds");
            if (logWriter != null) {
                logWriter.traceEntry((Object)this, "getPooledConnection", (Object)string, (Object)"<escaped>");
            }
            PooledConnection pooledConnection = ClientBaseDataSourceRoot.getPooledConnectionX(logWriter, this, string, string2);
            if (logWriter != null) {
                logWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    private static PooledConnection getPooledConnectionX(LogWriter logWriter, ClientBaseDataSourceRoot clientBaseDataSourceRoot, String string, String string2) throws SQLException {
        return ClientDriver.getFactory().newClientPooledConnection(clientBaseDataSourceRoot, logWriter, string, string2);
    }

    protected final XAConnection getXAConnectionMinion() throws SQLException {
        NetLogWriter netLogWriter = null;
        try {
            this.updateDataSourceValues(ClientBaseDataSourceRoot.tokenizeAttributes(this.getConnectionAttributes(), null));
            netLogWriter = (NetLogWriter)this.computeDncLogWriterForNewConnection("_xads");
            return ClientBaseDataSourceRoot.getXAConnectionX(netLogWriter, this, this.getUser(), this.getPassword());
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(netLogWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    protected final XAConnection getXAConnectionMinion(String string, String string2) throws SQLException {
        NetLogWriter netLogWriter = null;
        try {
            this.updateDataSourceValues(ClientBaseDataSourceRoot.tokenizeAttributes(this.getConnectionAttributes(), null));
            netLogWriter = (NetLogWriter)this.computeDncLogWriterForNewConnection("_xads");
            return ClientBaseDataSourceRoot.getXAConnectionX(netLogWriter, this, string, string2);
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(netLogWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    private static XAConnection getXAConnectionX(LogWriter logWriter, ClientBaseDataSourceRoot clientBaseDataSourceRoot, String string, String string2) throws SQLException {
        return ClientDriver.getFactory().newClientXAConnection(clientBaseDataSourceRoot, logWriter, string, string2);
    }

    public static Properties getProperties(ClientBaseDataSourceRoot clientBaseDataSourceRoot) {
        Properties properties = new Properties();
        Method[] methodArray = clientBaseDataSourceRoot.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?> clazz;
            String string;
            Method method = methodArray[i];
            if (method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || (string = method.getName()).length() < 5 || !string.startsWith("get") || !Integer.TYPE.equals(clazz = method.getReturnType()) && !Short.TYPE.equals(clazz) && !String.class.equals(clazz) && !Boolean.TYPE.equals(clazz)) continue;
            String string2 = string.substring(3, 4).toLowerCase(Locale.ENGLISH).concat(string.substring(4));
            try {
                Object object = method.invoke((Object)clientBaseDataSourceRoot, (Object[])null);
                if (object == null) continue;
                properties.setProperty(string2, object.toString());
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return properties;
    }

    static {
        boolean bl = false;
        try {
            new EncryptionManager(null);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        SUPPORTS_EUSRIDPWD = bl;
    }
}

