/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.util;

import org.apache.directory.api.asn1.util.Asn1StringUtils;

public class Asn1Buffer2 {
    private static final int DEFAULT_SIZE = 1024;
    private int pos = 0;
    private int size = 1024;
    private InternalBuffer currentBuffer = new InternalBuffer();

    public int getPos() {
        return this.pos;
    }

    public void put(byte b) {
        if (this.pos == this.size) {
            this.extend();
        }
        ((InternalBuffer)this.currentBuffer).buffer[this.size - this.pos - 1] = b;
        ++this.pos;
    }

    public void put(byte[] bytes) {
        int room;
        int dataLength = bytes.length;
        while (dataLength > (room = this.size - this.pos)) {
            System.arraycopy(bytes, dataLength - room, this.currentBuffer, 0, room);
            dataLength -= room;
            this.pos += room;
            this.extend();
        }
        System.arraycopy(bytes, 0, this.currentBuffer, room - dataLength, dataLength);
        this.pos += dataLength;
    }

    private void extend() {
        InternalBuffer newCurrentBuffer = new InternalBuffer();
        newCurrentBuffer.next = this.currentBuffer;
        this.currentBuffer = newCurrentBuffer;
        this.size += 1024;
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.pos];
        InternalBuffer bufferPtr = this.currentBuffer;
        int currentPos = 0;
        int dataPos = this.size - this.pos;
        int dataLength = 1024 - dataPos;
        while (bufferPtr.next != null) {
            System.arraycopy(bufferPtr, dataPos, result, currentPos, dataLength);
            currentPos += dataLength;
            dataPos = 0;
            dataLength = 1024;
        }
        return result;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        this.pos = 0;
        this.size = 1024;
        while (this.currentBuffer.next != null) {
            this.currentBuffer = this.currentBuffer.next;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.size).append(", ").append(this.pos).append("] )");
        InternalBuffer bufferPtr = this.currentBuffer;
        while (bufferPtr.next != null) {
            sb.append("\n    ").append(Asn1StringUtils.dumpBytes(bufferPtr.buffer));
        }
        return sb.toString();
    }

    private final class InternalBuffer {
        private byte[] buffer = new byte[1024];
        private InternalBuffer next;

        InternalBuffer() {
        }
    }
}

