/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.api.dsmlv2.DsmlControl;
import org.apache.directory.api.dsmlv2.DsmlDecorator;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;

public abstract class AbstractDsmlMessageDecorator<M extends Message>
implements DsmlDecorator<M>,
Message {
    private final LdapApiService codec;
    private final M message;
    private final Map<String, Control> controls;
    private DsmlControl<? extends Control> currentControl;

    public AbstractDsmlMessageDecorator(LdapApiService codec, M message) {
        this.codec = codec;
        this.message = message;
        this.controls = new HashMap<String, Control>();
    }

    public DsmlControl<? extends Control> getCurrentControl() {
        return this.currentControl;
    }

    public LdapApiService getCodecService() {
        return this.codec;
    }

    public MessageTypeEnum getType() {
        return this.message.getType();
    }

    public Map<String, Control> getControls() {
        return this.controls;
    }

    public Control getControl(String oid) {
        return this.controls.get(oid);
    }

    public boolean hasControl(String oid) {
        return this.controls.containsKey(oid);
    }

    public Message addControl(Control control) {
        Object decorated;
        DsmlControl<CodecControl> decorator;
        if (control instanceof DsmlControl) {
            decorator = (DsmlControl<CodecControl>)control;
            decorated = decorator.getDecorated();
        } else {
            decorator = new DsmlControl<CodecControl>(this.codec, this.codec.newControl(control));
            decorated = control;
        }
        this.message.addControl(decorated);
        this.controls.put(control.getOid(), decorator);
        this.currentControl = decorator;
        return this;
    }

    public Message addAllControls(Control[] controlsToAdd) {
        for (Control control : controlsToAdd) {
            this.addControl(control);
        }
        return this;
    }

    public Message removeControl(Control control) {
        this.controls.remove(control.getOid());
        this.message.removeControl(control);
        return this;
    }

    public int getMessageId() {
        return this.message.getMessageId();
    }

    public Object get(Object key) {
        return this.message.get(key);
    }

    public Object put(Object key, Object value) {
        return this.message.put(key, value);
    }

    public Message setMessageId(int messageId) {
        this.message.setMessageId(messageId);
        return this;
    }

    @Override
    public M getDecorated() {
        return this.message;
    }
}

