/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.search;

import org.apache.directory.api.ldap.model.filter.FilterEncoder;
import org.apache.directory.ldap.client.api.search.AbstractFilter;
import org.apache.directory.ldap.client.api.search.FilterOperator;

class AttributeValueAssertionFilter
extends AbstractFilter {
    private String attribute;
    private String value;
    private FilterOperator operator;

    private AttributeValueAssertionFilter(String attribute, String value, FilterOperator operator) {
        this.attribute = attribute;
        this.value = value;
        this.operator = operator;
    }

    public static AttributeValueAssertionFilter approximatelyEqual(String attribute, String value) {
        return new AttributeValueAssertionFilter(attribute, value, FilterOperator.APPROXIMATELY_EQUAL);
    }

    public static AttributeValueAssertionFilter equal(String attribute, String value) {
        return new AttributeValueAssertionFilter(attribute, value, FilterOperator.EQUAL);
    }

    public static AttributeValueAssertionFilter greaterThanOrEqual(String attribute, String value) {
        return new AttributeValueAssertionFilter(attribute, value, FilterOperator.GREATER_THAN_OR_EQUAL);
    }

    public static AttributeValueAssertionFilter lessThanOrEqual(String attribute, String value) {
        return new AttributeValueAssertionFilter(attribute, value, FilterOperator.LESS_THAN_OR_EQUAL);
    }

    @Override
    public StringBuilder build(StringBuilder builder) {
        return builder.append("(").append(this.attribute).append(this.operator.operator()).append(FilterEncoder.encodeFilterValue((String)this.value)).append(")");
    }
}

