/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.lang.reflect.Constructor;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnectionValidator;
import org.apache.directory.ldap.client.api.LookupLdapConnectionValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPoolableLdapConnectionFactory
implements PooledObjectFactory<LdapConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPoolableLdapConnectionFactory.class);
    protected LdapConnectionFactory connectionFactory;
    protected LdapConnectionValidator validator = new LookupLdapConnectionValidator();

    public AbstractPoolableLdapConnectionFactory(LdapConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void activateObject(PooledObject<LdapConnection> connection) throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_04146_ACTIVATING, (Object[])new Object[]{connection}));
        }
        if (!((LdapConnection)connection.getObject()).isConnected() || !((LdapConnection)connection.getObject()).isAuthenticated()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_04147_REBIND_CONNECTION_DROPPED, (Object[])new Object[]{connection}));
            }
            this.connectionFactory.bindConnection((LdapConnection)connection.getObject());
        }
    }

    public void destroyObject(PooledObject<LdapConnection> connection) throws LdapException {
        block3: {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_04148_DESTROYING, (Object[])new Object[]{connection}));
            }
            try {
                ((LdapConnection)connection.getObject()).unBind();
            }
            catch (LdapException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04100_UNABLE_TO_UNBIND, (Object[])new Object[]{e.getMessage()}));
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(I18n.msg((I18n)I18n.MSG_04149_UNABLE_TO_UNBIND, (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    public LdapApiService getLdapApiService() {
        return this.connectionFactory.getLdapApiService();
    }

    public PooledObject<LdapConnection> makeObject() throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_04150_CREATING_LDAP_CONNECTION, (Object[])new Object[0]));
        }
        return new DefaultPooledObject((Object)this.connectionFactory.newLdapConnection());
    }

    protected static LdapConnectionFactory newLdapConnectionFactory(LdapConnectionConfig config, Class<? extends LdapConnectionFactory> connectionFactoryClass) {
        try {
            Constructor<? extends LdapConnectionFactory> constructor = connectionFactoryClass.getConstructor(LdapConnectionConfig.class);
            return constructor.newInstance(config);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04101_CANNOT_CREATE_LDAP_CONNECTION_FACTORY, (Object[])new Object[]{e.getMessage(), e}));
        }
    }

    public void passivateObject(PooledObject<LdapConnection> connection) throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_04151_PASSIVATING, (Object[])new Object[]{connection}));
        }
    }

    public void setValidator(LdapConnectionValidator validator) {
        this.validator = validator;
    }

    public boolean validateObject(PooledObject<LdapConnection> connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_04152_VALIDATING, (Object[])new Object[]{connection}));
        }
        return this.validator.validate((LdapConnection)connection.getObject());
    }

    private static class PooledLdapConnectionFactory
    implements LdapConnectionFactory {
        private final LdapConnectionFactory delegate;

        PooledLdapConnectionFactory(LdapConnectionFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public LdapConnection bindConnection(LdapConnection connection) throws LdapException {
            return this.delegate.bindConnection(connection);
        }

        @Override
        public LdapConnection configureConnection(LdapConnection connection) {
            return this.delegate.configureConnection(connection);
        }

        @Override
        public LdapApiService getLdapApiService() {
            return this.delegate.getLdapApiService();
        }

        @Override
        public LdapConnection newLdapConnection() throws LdapException {
            return this.delegate.newLdapConnection();
        }

        @Override
        public LdapConnection newUnboundLdapConnection() {
            return this.delegate.newUnboundLdapConnection();
        }
    }
}

