/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.vlv_impl;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewRequest;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewRequestImpl;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewRequestContainer;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewerTags;
import org.apache.directory.api.ldap.model.message.Control;

public class VirtualListViewRequestDecorator
extends ControlDecorator<VirtualListViewRequest>
implements VirtualListViewRequest {
    private int vlvSeqLength;
    private int targetSeqLength;
    private static final Asn1Decoder decoder = new Asn1Decoder();

    public VirtualListViewRequestDecorator(LdapApiService codec) {
        this(codec, (VirtualListViewRequest)new VirtualListViewRequestImpl());
    }

    public VirtualListViewRequestDecorator(LdapApiService codec, VirtualListViewRequest vlvRequest) {
        super(codec, (Control)vlvRequest);
    }

    public int computeLength() {
        this.vlvSeqLength = 2 + BerValue.getNbBytes((int)this.getBeforeCount());
        this.vlvSeqLength += 2 + BerValue.getNbBytes((int)this.getAfterCount());
        if (this.hasOffset()) {
            this.targetSeqLength = 2 + BerValue.getNbBytes((int)this.getOffset());
            this.targetSeqLength += 2 + BerValue.getNbBytes((int)this.getContentCount());
            this.vlvSeqLength += 2 + this.targetSeqLength;
        } else {
            byte[] assertionValue = this.getAssertionValue();
            this.targetSeqLength = assertionValue != null ? 1 + TLV.getNbBytes((int)assertionValue.length) + assertionValue.length : 2;
            this.vlvSeqLength += this.targetSeqLength;
        }
        if (this.getContextId() != null) {
            this.vlvSeqLength += 1 + TLV.getNbBytes((int)this.getContextId().length) + this.getContextId().length;
        }
        this.valueLength = 1 + TLV.getNbBytes((int)this.vlvSeqLength) + this.vlvSeqLength;
        return this.valueLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04023, (Object[])new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes((int)this.vlvSeqLength));
        BerValue.encode((ByteBuffer)buffer, (int)this.getBeforeCount());
        BerValue.encode((ByteBuffer)buffer, (int)this.getAfterCount());
        if (this.hasOffset()) {
            buffer.put((byte)VirtualListViewerTags.BY_OFFSET_TAG.getValue());
            buffer.put(TLV.getBytes((int)this.targetSeqLength));
            BerValue.encode((ByteBuffer)buffer, (int)this.getOffset());
            BerValue.encode((ByteBuffer)buffer, (int)this.getContentCount());
        } else {
            buffer.put((byte)VirtualListViewerTags.ASSERTION_VALUE_TAG.getValue());
            byte[] value = this.getAssertionValue();
            if (value != null) {
                buffer.put(TLV.getBytes((int)value.length));
            } else {
                buffer.put(TLV.getBytes((int)0));
            }
            buffer.put(value);
        }
        if (this.getContextId() != null) {
            BerValue.encode((ByteBuffer)buffer, (byte[])this.getContextId());
        }
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                this.value = this.encode(buffer).array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer buffer = ByteBuffer.wrap(controlBytes);
        VirtualListViewRequestContainer container = new VirtualListViewRequestContainer(this, this.getCodecService());
        decoder.decode(buffer, (Asn1Container)container);
        return this;
    }

    public int getBeforeCount() {
        return ((VirtualListViewRequest)this.getDecorated()).getBeforeCount();
    }

    public void setBeforeCount(int beforeCount) {
        ((VirtualListViewRequest)this.getDecorated()).setBeforeCount(beforeCount);
    }

    public int getAfterCount() {
        return ((VirtualListViewRequest)this.getDecorated()).getAfterCount();
    }

    public void setAfterCount(int afterCount) {
        ((VirtualListViewRequest)this.getDecorated()).setAfterCount(afterCount);
    }

    public int getOffset() {
        return ((VirtualListViewRequest)this.getDecorated()).getOffset();
    }

    public void setOffset(int offset) {
        ((VirtualListViewRequest)this.getDecorated()).setOffset(offset);
    }

    public int getContentCount() {
        return ((VirtualListViewRequest)this.getDecorated()).getContentCount();
    }

    public void setContentCount(int contentCount) {
        ((VirtualListViewRequest)this.getDecorated()).setContentCount(contentCount);
    }

    public byte[] getContextId() {
        return ((VirtualListViewRequest)this.getDecorated()).getContextId();
    }

    public void setContextId(byte[] contextId) {
        ((VirtualListViewRequest)this.getDecorated()).setContextId(contextId);
    }

    public byte[] getAssertionValue() {
        return ((VirtualListViewRequest)this.getDecorated()).getAssertionValue();
    }

    public void setAssertionValue(byte[] assertionValue) {
        ((VirtualListViewRequest)this.getDecorated()).setAssertionValue(assertionValue);
    }

    public boolean hasOffset() {
        return ((VirtualListViewRequest)this.getDecorated()).hasOffset();
    }

    public boolean hasAssertionValue() {
        return ((VirtualListViewRequest)this.getDecorated()).hasAssertionValue();
    }
}

