/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIResponseContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIResponseDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIResponseStatesEnum;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponse;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponseImpl;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhoAmIResponseGrammar
extends AbstractGrammar<WhoAmIResponseContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(WhoAmIResponseGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<WhoAmIResponseContainer> instance = new WhoAmIResponseGrammar();

    public WhoAmIResponseGrammar() {
        this.setName(WhoAmIResponseGrammar.class.getName());
        this.transitions = new GrammarTransition[WhoAmIResponseStatesEnum.LAST_WHO_AM_I_RESPONSE_STATE.ordinal()][256];
        this.transitions[WhoAmIResponseStatesEnum.START_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)WhoAmIResponseStatesEnum.START_STATE, (Enum)WhoAmIResponseStatesEnum.AUTHZ_ID_RESPONSE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<WhoAmIResponseContainer>("Store AuthzId"){

            public void action(WhoAmIResponseContainer container) throws DecoderException {
                WhoAmIResponseDecorator whoAmIResponse = new WhoAmIResponseDecorator(LdapApiServiceFactory.getSingleton(), (WhoAmIResponse)new WhoAmIResponseImpl());
                container.setWhoAmIResponse(whoAmIResponse);
                byte[] data = container.getCurrentTLV().getValue().getData();
                if (data != null) {
                    block1 : switch (data.length) {
                        case 0: 
                        case 1: {
                            String msg = "authzId too short. Must starts with either u: or dn:";
                            LOG.error(msg);
                            throw new DecoderException(msg);
                        }
                        case 2: {
                            if (data[0] == 117 && data[1] == 58) {
                                whoAmIResponse.setAuthzId(data);
                                whoAmIResponse.setUserId(Strings.utf8ToString((byte[])data, (int)3, (int)(data.length - 3)));
                                break;
                            }
                            String msg = "authzId Must starts with either u: or dn:, it starts with " + Strings.utf8ToString((byte[])data);
                            LOG.error(msg);
                            throw new DecoderException(msg);
                        }
                        default: {
                            switch (data[0]) {
                                case 117: {
                                    if (data[1] == 58) {
                                        whoAmIResponse.setAuthzId(data);
                                        whoAmIResponse.setUserId(Strings.utf8ToString((byte[])data, (int)3, (int)(data.length - 3)));
                                        break block1;
                                    }
                                    String msg = "authzId Must starts with either u: or dn:, it starts with " + Strings.utf8ToString((byte[])data);
                                    LOG.error(msg);
                                    throw new DecoderException(msg);
                                }
                                case 100: {
                                    if (data[1] == 110 && data[2] == 58) {
                                        if (Dn.isValid((String)Strings.utf8ToString((byte[])data, (int)3, (int)(data.length - 3)))) {
                                            whoAmIResponse.setAuthzId(data);
                                            try {
                                                whoAmIResponse.setDn(new Dn(new String[]{Strings.utf8ToString((byte[])data, (int)3, (int)(data.length - 3))}));
                                            }
                                            catch (LdapInvalidDnException ldapInvalidDnException) {}
                                            break block1;
                                        }
                                        String msg = "authzId Must starts with either u: or dn:, it starts with " + Strings.utf8ToString((byte[])data);
                                        LOG.error(msg);
                                        throw new DecoderException(msg);
                                    }
                                    String msg = "authzId Must starts with either u: or dn:, it starts with " + Strings.utf8ToString((byte[])data);
                                    LOG.error(msg);
                                    throw new DecoderException(msg);
                                }
                            }
                            String msg = "authzId Must starts with either u: or dn:, it starts with " + Strings.utf8ToString((byte[])data);
                            LOG.error(msg);
                            throw new DecoderException(msg);
                        }
                    }
                } else {
                    whoAmIResponse.setAuthzId(null);
                }
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<WhoAmIResponseContainer> getInstance() {
        return instance;
    }
}

