/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationRequestContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationRequestStatesEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertGenerationRequestGrammar
extends AbstractGrammar<CertGenerationRequestContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(CertGenerationRequestGrammar.class);
    private static Grammar<CertGenerationRequestContainer> instance = new CertGenerationRequestGrammar();

    public CertGenerationRequestGrammar() {
        this.setName(CertGenerationRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[CertGenerationRequestStatesEnum.LAST_CERT_GENERATION_STATE.ordinal()][256];
        this.transitions[CertGenerationRequestStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)CertGenerationRequestStatesEnum.START_STATE, (Enum)CertGenerationRequestStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null, Grammar.FollowUp.MANDATORY);
        this.transitions[CertGenerationRequestStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)CertGenerationRequestStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE, (Enum)CertGenerationRequestStatesEnum.TARGETDN_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<CertGenerationRequestContainer>("Set Cert Generation target Dn value"){

            public void action(CertGenerationRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String targetDN = Strings.utf8ToString((byte[])value.getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08215_TARGET_DN, (Object[])new Object[]{targetDN}));
                }
                if (targetDN != null && targetDN.trim().length() > 0) {
                    if (!Dn.isValid((String)targetDN)) {
                        String msg = I18n.err((I18n)I18n.ERR_08201_INVALID_TARGET_DN, (Object[])new Object[]{targetDN});
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                } else {
                    String msg = I18n.err((I18n)I18n.ERR_08202_NULL_TARGET_DN_DECODING_FAILED, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.getCertGenerationRequest().setTargetDN(targetDN);
            }
        }, Grammar.FollowUp.MANDATORY);
        this.transitions[CertGenerationRequestStatesEnum.TARGETDN_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)CertGenerationRequestStatesEnum.TARGETDN_STATE, (Enum)CertGenerationRequestStatesEnum.ISSUER_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<CertGenerationRequestContainer>("Set Cert Generation issuer Dn value"){

            public void action(CertGenerationRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String issuerDN = Strings.utf8ToString((byte[])value.getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08207_ISSUER_DN, (Object[])new Object[]{issuerDN}));
                }
                if (issuerDN != null && issuerDN.trim().length() > 0) {
                    if (!Dn.isValid((String)issuerDN)) {
                        String msg = I18n.err((I18n)I18n.ERR_08203_INVALID_ISSUER_DN, (Object[])new Object[]{issuerDN});
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                    container.getCertGenerationRequest().setIssuerDN(issuerDN);
                }
            }
        }, Grammar.FollowUp.MANDATORY);
        this.transitions[CertGenerationRequestStatesEnum.ISSUER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)CertGenerationRequestStatesEnum.ISSUER_STATE, (Enum)CertGenerationRequestStatesEnum.SUBJECT_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<CertGenerationRequestContainer>("Set Cert Generation subject Dn value"){

            public void action(CertGenerationRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String subjectDN = Strings.utf8ToString((byte[])value.getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08219_SUBJECT_DN, (Object[])new Object[]{subjectDN}));
                }
                if (subjectDN != null && subjectDN.trim().length() > 0) {
                    if (!Dn.isValid((String)subjectDN)) {
                        String msg = I18n.err((I18n)I18n.ERR_08204_INVALID_SUBJECT_DN, (Object[])new Object[]{subjectDN});
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                } else {
                    String msg = I18n.err((I18n)I18n.ERR_08202_NULL_TARGET_DN_DECODING_FAILED, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.getCertGenerationRequest().setSubjectDN(subjectDN);
            }
        }, Grammar.FollowUp.MANDATORY);
        this.transitions[CertGenerationRequestStatesEnum.SUBJECT_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)CertGenerationRequestStatesEnum.SUBJECT_STATE, (Enum)CertGenerationRequestStatesEnum.KEY_ALGORITHM_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<CertGenerationRequestContainer>("Set Cert Generation key algorithm value"){

            public void action(CertGenerationRequestContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                String keyAlgorithm = Strings.utf8ToString((byte[])value.getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08218_KEY_ALGORITHM, (Object[])new Object[]{keyAlgorithm}));
                }
                if (keyAlgorithm != null && keyAlgorithm.trim().length() > 0) {
                    container.getCertGenerationRequest().setKeyAlgorithm(keyAlgorithm);
                }
                container.setGrammarEndAllowed(true);
            }
        }, Grammar.FollowUp.OPTIONAL);
    }

    public static Grammar<CertGenerationRequestContainer> getInstance() {
        return instance;
    }
}

