/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.ControlsContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.ControlsStates;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.actions.AddControl;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.actions.StoreControlCriticality;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.actions.StoreControlValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlsGrammar
extends AbstractGrammar<ControlsContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(ControlsGrammar.class);
    private static Grammar<ControlsContainer> instance = new ControlsGrammar();

    public ControlsGrammar() {
        this.setName(ControlsGrammar.class.getName());
        this.transitions = new GrammarTransition[ControlsStates.LAST_STATE.ordinal()][256];
        this.transitions[ControlsStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)ControlsStates.START_STATE, (Enum)ControlsStates.CONTROL_SEQUENCE_STATE, UniversalTag.SEQUENCE, (Action)new GrammarAction<ControlsContainer>("Init Control"){

            public void action(ControlsContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                int expectedLength = tlv.getLength();
                if (expectedLength == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_08213_NULL_CONTROL_LENGTH, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        }, Grammar.FollowUp.OPTIONAL);
        this.transitions[ControlsStates.CONTROL_SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)ControlsStates.CONTROL_SEQUENCE_STATE, (Enum)ControlsStates.CONTROL_TYPE_STATE, UniversalTag.OCTET_STRING, (Action)new AddControl(), Grammar.FollowUp.OPTIONAL);
        this.transitions[ControlsStates.CONTROL_TYPE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)ControlsStates.CONTROL_TYPE_STATE, (Enum)ControlsStates.CONTROL_CRITICALITY_STATE, UniversalTag.BOOLEAN, (Action)new StoreControlCriticality(), Grammar.FollowUp.OPTIONAL);
        this.transitions[ControlsStates.CONTROL_TYPE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)ControlsStates.CONTROL_TYPE_STATE, (Enum)ControlsStates.CONTROL_VALUE_STATE, UniversalTag.OCTET_STRING, (Action)new StoreControlValue(), Grammar.FollowUp.OPTIONAL);
        this.transitions[ControlsStates.CONTROL_TYPE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)ControlsStates.CONTROL_TYPE_STATE, (Enum)ControlsStates.CONTROL_SEQUENCE_STATE, UniversalTag.SEQUENCE, Grammar.FollowUp.OPTIONAL);
        this.transitions[ControlsStates.CONTROL_CRITICALITY_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)ControlsStates.CONTROL_CRITICALITY_STATE, (Enum)ControlsStates.CONTROL_VALUE_STATE, UniversalTag.OCTET_STRING, (Action)new StoreControlValue(), Grammar.FollowUp.OPTIONAL);
        this.transitions[ControlsStates.CONTROL_CRITICALITY_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)ControlsStates.CONTROL_CRITICALITY_STATE, (Enum)ControlsStates.CONTROL_SEQUENCE_STATE, UniversalTag.SEQUENCE, Grammar.FollowUp.OPTIONAL);
        this.transitions[ControlsStates.CONTROL_VALUE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)ControlsStates.CONTROL_VALUE_STATE, (Enum)ControlsStates.CONTROL_SEQUENCE_STATE, UniversalTag.SEQUENCE, Grammar.FollowUp.OPTIONAL);
    }

    public static Grammar<ControlsContainer> getInstance() {
        return instance;
    }
}

