/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeletexTerminalIdentifierSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(TeletexTerminalIdentifierSyntaxChecker.class);

    public TeletexTerminalIdentifierSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.51");
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String terminalIdentifier;
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int dollar = strValue.indexOf(36);
        String string = terminalIdentifier = dollar == -1 ? strValue : strValue.substring(0, dollar);
        if (terminalIdentifier.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (!Strings.isPrintableString((String)terminalIdentifier)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (dollar == -1) {
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        String[] ttxParams = strValue.substring(dollar + 1).split("\\$");
        if (ttxParams.length == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        for (String ttxParam : ttxParams) {
            int colon = ttxParam.indexOf(58);
            if (colon == -1) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            String key = ttxParam.substring(0, colon);
            if (key.startsWith("graphic") || key.startsWith("control") || key.startsWith("misc") || key.startsWith("page") || key.startsWith("private")) {
                if (colon + 1 == ttxParam.length()) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                boolean hasEsc = false;
                block9: for (byte b : Strings.getBytesUtf8((String)ttxParam)) {
                    switch (b) {
                        case 36: {
                            LOG.debug("Syntax invalid for '{}'", value);
                            return false;
                        }
                        case 92: {
                            if (hasEsc) {
                                LOG.debug("Syntax invalid for '{}'", value);
                                return false;
                            }
                            hasEsc = true;
                            continue block9;
                        }
                        case 50: {
                            continue block9;
                        }
                        case 52: {
                            hasEsc = false;
                            continue block9;
                        }
                        case 53: {
                            continue block9;
                        }
                        case 67: 
                        case 99: {
                            hasEsc = false;
                            continue block9;
                        }
                        default: {
                            if (!hasEsc) continue block9;
                            return false;
                        }
                    }
                }
                continue;
            }
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        LOG.debug("Syntax valid for '{}'", value);
        return true;
    }
}

