/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.SchemaObjectRenderer;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;

public class LdapSyntax
extends AbstractSchemaObject {
    public static final long serialVersionUID = 1L;
    protected boolean isHumanReadable = false;
    private boolean hasHumanReadableFlag = false;
    protected SyntaxChecker syntaxChecker;

    public LdapSyntax(String oid) {
        super(SchemaObjectType.LDAP_SYNTAX, oid);
    }

    public LdapSyntax(String oid, String description) {
        super(SchemaObjectType.LDAP_SYNTAX, oid);
        this.description = description;
        this.hasHumanReadableFlag = false;
    }

    public LdapSyntax(String oid, String description, boolean isHumanReadable) {
        super(SchemaObjectType.LDAP_SYNTAX, oid);
        this.description = description;
        this.isHumanReadable = isHumanReadable;
        this.hasHumanReadableFlag = true;
    }

    public boolean isHumanReadable() {
        if (this.hasHumanReadableFlag) {
            return this.isHumanReadable;
        }
        List values = (List)this.extensions.get("x-not-human-readable");
        if (values == null || values.size() == 0) {
            return false;
        }
        String value = (String)values.get(0);
        this.hasHumanReadableFlag = true;
        if (value.equalsIgnoreCase("FALSE")) {
            this.isHumanReadable = true;
            return true;
        }
        this.isHumanReadable = false;
        return false;
    }

    public void setHumanReadable(boolean humanReadable) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.isHumanReadable = humanReadable;
            this.hasHumanReadableFlag = true;
        }
    }

    public SyntaxChecker getSyntaxChecker() {
        return this.syntaxChecker;
    }

    public void setSyntaxChecker(SyntaxChecker syntaxChecker) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.syntaxChecker = syntaxChecker;
        }
    }

    public void updateSyntaxChecker(SyntaxChecker newSyntaxChecker) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        this.syntaxChecker = newSyntaxChecker;
    }

    public String toString() {
        return SchemaObjectRenderer.OPEN_LDAP_SCHEMA_RENDERER.render(this);
    }

    @Override
    public LdapSyntax copy() {
        LdapSyntax copy = new LdapSyntax(this.oid);
        copy.copy(this);
        copy.isHumanReadable = this.isHumanReadable;
        copy.hasHumanReadableFlag = this.hasHumanReadableFlag;
        copy.syntaxChecker = null;
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LdapSyntax)) {
            return false;
        }
        LdapSyntax that = (LdapSyntax)o;
        if (this.isHumanReadable != that.isHumanReadable) {
            return false;
        }
        if (this.syntaxChecker != null) {
            if (that.syntaxChecker == null) {
                return false;
            }
            return this.syntaxChecker.getOid().equals(that.syntaxChecker.getOid());
        }
        return that.syntaxChecker == null;
    }

    @Override
    public void clear() {
        super.clear();
        this.syntaxChecker = null;
    }
}

