/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.normalizers.DeepTrimToLowerNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepTrimToLowerComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(DeepTrimToLowerComparator.class);

    public DeepTrimToLowerComparator(String oid) {
        super(oid);
        this.normalizer = new DeepTrimToLowerNormalizer();
    }

    @Override
    public int compare(String key, String value) {
        String normalizedValue;
        try {
            normalizedValue = this.normalizer.normalize(value);
        }
        catch (LdapException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(I18n.msg((I18n)I18n.MSG_13700_FAILED_TO_NORMALIZE, (Object[])new Object[]{value}), (Throwable)e);
            }
            normalizedValue = value;
        }
        return key.compareTo(normalizedValue);
    }
}

