/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.ComplexDnParser;
import org.apache.directory.api.ldap.model.name.FastDnParser;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.name.TooComplexDnException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dn
implements Iterable<Rdn>,
Externalizable {
    protected static final Logger LOG = LoggerFactory.getLogger(Dn.class);
    private static final long serialVersionUID = 1L;
    public static final int NOT_EQUAL = -1;
    public static final int EQUAL = 0;
    protected transient List<Rdn> rdns;
    private String upName;
    private String normName;
    public static final Dn EMPTY_DN = new Dn();
    public static final Dn ROOT_DSE = new Dn();
    private transient SchemaManager schemaManager;
    private static final boolean LEFT = true;
    private static final boolean RIGHT = false;

    public Dn() {
        this((SchemaManager)null);
    }

    public Dn(SchemaManager schemaManager) {
        this.rdns = new ArrayList<Rdn>(5);
        this.schemaManager = schemaManager;
        this.upName = "";
        this.normName = "";
    }

    public Dn(SchemaManager schemaManager, Dn dn) throws LdapInvalidDnException {
        this.rdns = new ArrayList<Rdn>(5);
        this.schemaManager = schemaManager;
        if (dn == null) {
            return;
        }
        for (Rdn rdn : dn.rdns) {
            this.rdns.add(new Rdn(schemaManager, rdn));
        }
        this.upName = this.toUpName();
    }

    public Dn(String ... upRdns) throws LdapInvalidDnException {
        this((SchemaManager)null, upRdns);
    }

    public Dn(SchemaManager schemaManager, String ... upRdns) throws LdapInvalidDnException {
        block8: {
            this.rdns = new ArrayList<Rdn>(5);
            StringBuilder sbUpName = new StringBuilder();
            boolean valueExpected = false;
            boolean isFirst = true;
            this.schemaManager = schemaManager;
            for (String upRdn : upRdns) {
                if (Strings.isEmpty((String)upRdn)) continue;
                if (isFirst) {
                    isFirst = false;
                } else if (!valueExpected) {
                    sbUpName.append(',');
                }
                if (!valueExpected) {
                    sbUpName.append(upRdn);
                    if (upRdn.indexOf(61) != -1) continue;
                    valueExpected = true;
                    continue;
                }
                sbUpName.append("=").append(upRdn);
                valueExpected = false;
            }
            if (!isFirst && valueExpected) {
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err((I18n)I18n.ERR_13611_VALUE_MISSING_ON_RDN, (Object[])new Object[0]));
            }
            this.upName = sbUpName.toString();
            try {
                this.normName = Dn.parseInternal(schemaManager, this.upName, this.rdns);
            }
            catch (LdapInvalidDnException e) {
                if (schemaManager != null && schemaManager.isRelaxed()) break block8;
                throw e;
            }
        }
    }

    public Dn(Rdn ... rdns) throws LdapInvalidDnException {
        this.rdns = new ArrayList<Rdn>(5);
        if (rdns == null) {
            return;
        }
        for (Rdn rdn : rdns) {
            this.rdns.add(rdn);
        }
        this.toUpName();
    }

    public Dn(Rdn rdn, Dn dn) throws LdapInvalidDnException {
        this.rdns = new ArrayList<Rdn>(5);
        if (dn == null || rdn == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_13622_DN_OR_RDN_NULL, (Object[])new Object[0]));
        }
        for (Rdn rdnParent : dn) {
            this.rdns.add(0, rdnParent);
        }
        this.rdns.add(0, rdn);
        this.toUpName();
    }

    public Dn(SchemaManager schemaManager, Rdn ... rdns) throws LdapInvalidDnException {
        this.rdns = new ArrayList<Rdn>(5);
        this.schemaManager = schemaManager;
        if (rdns == null) {
            return;
        }
        for (Rdn rdn : rdns) {
            if (rdn.isSchemaAware()) {
                this.rdns.add(rdn);
                continue;
            }
            this.rdns.add(new Rdn(schemaManager, rdn));
        }
        this.toUpName();
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    private String toUpName() {
        if (this.rdns.isEmpty()) {
            this.upName = "";
            this.normName = "";
        } else {
            StringBuilder sbUpName = new StringBuilder();
            StringBuilder sbNormName = new StringBuilder();
            boolean isFirst = true;
            for (Rdn rdn : this.rdns) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sbUpName.append(',');
                    sbNormName.append(',');
                }
                sbUpName.append(rdn.getName());
                sbNormName.append(rdn.getNormName());
            }
            this.upName = sbUpName.toString();
            this.normName = sbNormName.toString();
        }
        return this.upName;
    }

    public int hashCode() {
        int result = 37;
        for (Rdn rdn : this.rdns) {
            result = result * 17 + rdn.hashCode();
        }
        return result;
    }

    public String getName() {
        return this.upName == null ? "" : this.upName;
    }

    public String getNormName() {
        return this.normName == null ? "" : this.normName;
    }

    public String getEscaped() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Rdn rdn : this.rdns) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(rdn.getEscaped());
        }
        return sb.toString();
    }

    void setUpName(String upName) {
        this.upName = upName;
    }

    void setNormName(String normName) {
        this.normName = normName;
    }

    public int size() {
        return this.rdns.size();
    }

    public boolean isAncestorOf(String dn) {
        try {
            return this.isAncestorOf(new Dn(dn));
        }
        catch (LdapInvalidDnException lide) {
            return false;
        }
    }

    public boolean isAncestorOf(Dn dn) {
        if (dn == null) {
            return false;
        }
        return dn.isDescendantOf(this);
    }

    public boolean isDescendantOf(String dn) {
        try {
            return this.isDescendantOf(new Dn(this.schemaManager, dn));
        }
        catch (LdapInvalidDnException lide) {
            return false;
        }
    }

    public boolean isDescendantOf(Dn dn) {
        if (dn == null || dn.isRootDse()) {
            return true;
        }
        if (dn.size() > this.size()) {
            return false;
        }
        for (int i = dn.size() - 1; i >= 0; --i) {
            Rdn ldapRdn;
            Rdn nameRdn = dn.rdns.get(dn.rdns.size() - i - 1);
            if (nameRdn.equals(ldapRdn = this.rdns.get(this.rdns.size() - i - 1))) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.rdns.isEmpty();
    }

    public boolean isRootDse() {
        return this.rdns.isEmpty();
    }

    public Rdn getRdn(int posn) {
        if (this.rdns.isEmpty()) {
            return null;
        }
        if (posn < 0 || posn >= this.rdns.size()) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_13623_INVALID_POSITION, (Object[])new Object[]{posn}));
        }
        return this.rdns.get(posn);
    }

    public Rdn getRdn() {
        if (Dn.isNullOrEmpty(this)) {
            return Rdn.EMPTY_RDN;
        }
        return this.rdns.get(0);
    }

    public List<Rdn> getRdns() {
        return UnmodifiableList.unmodifiableList(this.rdns);
    }

    public Dn getDescendantOf(String ancestor) throws LdapInvalidDnException {
        return this.getDescendantOf(new Dn(this.schemaManager, ancestor));
    }

    public Dn getDescendantOf(Dn ancestor) throws LdapInvalidDnException {
        int i;
        if (ancestor == null || ancestor.size() == 0) {
            return this;
        }
        if (this.rdns.isEmpty()) {
            return EMPTY_DN;
        }
        int length = ancestor.size();
        if (length > this.rdns.size()) {
            String message = I18n.err((I18n)I18n.ERR_13612_POSITION_NOT_IN_RANGE, (Object[])new Object[]{length, this.rdns.size()});
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        Dn newDn = new Dn(this.schemaManager);
        List<Rdn> rdnsAncestor = ancestor.getRdns();
        for (i = 0; i < ancestor.size(); ++i) {
            Rdn rdnDescendant;
            Rdn rdn = this.rdns.get(this.size() - 1 - i);
            if (rdn.equals(rdnDescendant = rdnsAncestor.get(ancestor.size() - 1 - i))) continue;
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX);
        }
        if (this.rdns.get(0).equals(rdnsAncestor.get(0))) {
            return newDn;
        }
        for (i = 0; i < this.rdns.size() - length; ++i) {
            newDn.rdns.add(this.rdns.get(i));
        }
        newDn.toUpName();
        return newDn;
    }

    public Dn getAncestorOf(String descendant) throws LdapInvalidDnException {
        return this.getAncestorOf(new Dn(this.schemaManager, descendant));
    }

    public Dn getAncestorOf(Dn descendant) throws LdapInvalidDnException {
        int i;
        int length = descendant.size();
        if (descendant == null || length == 0) {
            return this;
        }
        if (this.rdns.isEmpty() || length == this.rdns.size()) {
            return EMPTY_DN;
        }
        if (length > this.rdns.size()) {
            String message = I18n.err((I18n)I18n.ERR_13612_POSITION_NOT_IN_RANGE, (Object[])new Object[]{length, this.rdns.size()});
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        Dn newDn = new Dn(this.schemaManager);
        List<Rdn> rdnsDescendant = descendant.getRdns();
        for (i = 0; i < descendant.size(); ++i) {
            Rdn rdnDescendant;
            Rdn rdn = this.rdns.get(i);
            if (rdn.equals(rdnDescendant = rdnsDescendant.get(i))) continue;
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX);
        }
        for (i = length; i < this.rdns.size(); ++i) {
            newDn.rdns.add(this.rdns.get(i));
        }
        newDn.upName = this.upName.substring(descendant.upName.length() + 1);
        return newDn;
    }

    public Dn add(Dn rdns) throws LdapInvalidDnException {
        if (rdns == null || rdns.size() == 0) {
            return this;
        }
        Dn clonedDn = this.copy();
        clonedDn.rdns.addAll(0, rdns.rdns);
        if (clonedDn.isSchemaAware() && rdns.isSchemaAware()) {
            if (clonedDn.size() != 0) {
                clonedDn.upName = rdns.getName() + "," + this.upName;
            }
        } else {
            clonedDn.toUpName();
        }
        return clonedDn;
    }

    public Dn add(String rdn) throws LdapInvalidDnException {
        if (rdn.length() == 0) {
            return this;
        }
        Dn clonedDn = this.copy();
        Rdn newRdn = new Rdn(this.schemaManager, rdn);
        clonedDn.rdns.add(0, newRdn);
        clonedDn.toUpName();
        return clonedDn;
    }

    public Dn add(Rdn newRdn) throws LdapInvalidDnException {
        if (newRdn == null || newRdn.size() == 0) {
            return this;
        }
        Dn clonedDn = this.copy();
        clonedDn.rdns.add(0, new Rdn(this.schemaManager, newRdn));
        clonedDn.toUpName();
        return clonedDn;
    }

    public Dn getParent() {
        if (Dn.isNullOrEmpty(this)) {
            return this;
        }
        int posn = this.rdns.size() - 1;
        Dn newDn = new Dn(this.schemaManager);
        for (int i = this.rdns.size() - posn; i < this.rdns.size(); ++i) {
            newDn.rdns.add(this.rdns.get(i));
        }
        newDn.toUpName();
        return newDn;
    }

    private String removeUpName(String removedUpName, boolean fromLeft) {
        int removedSize = removedUpName.length();
        if (fromLeft) {
            for (int i = removedSize; i < this.upName.length(); ++i) {
                if (this.upName.charAt(i) != ',') continue;
                return this.upName.substring(i + 1);
            }
        } else {
            for (int i = this.upName.length() - removedSize; i > 0; --i) {
                if (this.upName.charAt(i) != ',') continue;
                return this.upName.substring(0, i - 1);
            }
        }
        return "";
    }

    private Dn copy() {
        Dn dn = new Dn(this.schemaManager);
        dn.rdns = new ArrayList<Rdn>();
        for (Rdn rdn : this.rdns) {
            dn.rdns.add(rdn);
        }
        return dn;
    }

    public boolean equals(Object obj) {
        Dn other;
        if (obj instanceof String) {
            try {
                other = new Dn(this.schemaManager, (String)obj);
            }
            catch (LdapInvalidDnException e) {
                return false;
            }
        } else if (obj instanceof Dn) {
            other = (Dn)obj;
        } else {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        if (this.isSchemaAware()) {
            if (this.normName == null) {
                return other.normName == null;
            }
            return this.normName.equals(other.normName);
        }
        for (int i = 0; i < this.size(); ++i) {
            if (other.rdns.get(i).equals(this.rdns.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isSchemaAware() {
        return this.schemaManager != null;
    }

    @Override
    public Iterator<Rdn> iterator() {
        return new RdnIterator();
    }

    public static boolean isNullOrEmpty(Dn dn) {
        return dn == null || dn.isEmpty();
    }

    public static boolean isValid(String name) {
        Dn dn = new Dn();
        try {
            Dn.parseInternal(null, name, dn.rdns);
            return true;
        }
        catch (LdapInvalidDnException e) {
            return false;
        }
    }

    public static boolean isValid(SchemaManager schemaManager, String name) {
        Dn dn = new Dn();
        try {
            Dn.parseInternal(schemaManager, name, dn.rdns);
            return true;
        }
        catch (LdapInvalidDnException e) {
            return false;
        }
    }

    private static String parseInternal(SchemaManager schemaManager, String name, List<Rdn> rdns) throws LdapInvalidDnException {
        try {
            return FastDnParser.parseDn(schemaManager, name, rdns);
        }
        catch (TooComplexDnException e) {
            rdns.clear();
            return new ComplexDnParser().parseDn(schemaManager, name, rdns);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.upName = in.readUTF();
        int nbRdns = in.readInt();
        this.rdns = new ArrayList<Rdn>(nbRdns);
        for (int i = 0; i < nbRdns; ++i) {
            Rdn rdn = new Rdn(this.schemaManager);
            rdn.readExternal(in);
            this.rdns.add(rdn);
        }
        this.toUpName();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.upName == null) {
            String message = I18n.err((I18n)I18n.ERR_13624_CANNOT_SERIALIZE_NULL_DN, (Object[])new Object[0]);
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeUTF(this.upName);
        out.writeInt(this.size());
        for (Rdn rdn : this.rdns) {
            rdn.writeExternal(out);
        }
        out.flush();
    }

    public String toString() {
        return this.getName();
    }

    private final class RdnIterator
    implements Iterator<Rdn> {
        int index;

        private RdnIterator() {
            this.index = Dn.this.rdns != null ? Dn.this.rdns.size() - 1 : -1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public Rdn next() {
            return this.index >= 0 ? Dn.this.rdns.get(this.index--) : null;
        }

        @Override
        public void remove() {
        }
    }
}

