/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server;

import java.io.File;
import org.apache.directory.daemon.DaemonApplication;
import org.apache.directory.daemon.InstallationLayout;
import org.apache.directory.server.configuration.ApacheDS;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.SocketAcceptor;
import org.apache.xbean.spring.context.FileSystemXmlApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service
implements DaemonApplication {
    private static final Logger LOG = LoggerFactory.getLogger(Service.class);
    private Thread workerThread;
    private SynchWorker worker = new SynchWorker();
    private ApacheDS apacheDS;
    private FileSystemXmlApplicationContext factory;
    public static final String BANNER = "           _                     _          ____  ____   \n          / \\   _ __   __ _  ___| |__   ___|  _ \\/ ___|  \n         / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ | | \\___ \\   \n        / ___ \\| |_) | (_| | (__| | | |  __/ |_| |___) |  \n       /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|____/|____/   \n               |_|                                                               \n";

    public void init(InstallationLayout install, String[] args) throws Exception {
        Service.printBanner();
        long startTime = System.currentTimeMillis();
        if (args.length > 0 && new File(args[0]).exists()) {
            LOG.info("server: loading settings from ", (Object)args[0]);
            this.factory = new FileSystemXmlApplicationContext(new File(args[0]).toURI().toURL().toString());
            this.apacheDS = (ApacheDS)this.factory.getBean("apacheDS");
        } else {
            LOG.info("server: using default settings ...");
            DefaultDirectoryService directoryService = new DefaultDirectoryService();
            directoryService.startup();
            SocketAcceptor socketAcceptor = new SocketAcceptor(null);
            LdapServer ldapServer = new LdapServer();
            ldapServer.setSocketAcceptor(socketAcceptor);
            ldapServer.setDirectoryService((DirectoryService)directoryService);
            ldapServer.start();
            LdapServer ldapsServer = new LdapServer();
            ldapsServer.setEnableLdaps(true);
            ldapsServer.setSocketAcceptor(socketAcceptor);
            ldapsServer.setDirectoryService((DirectoryService)directoryService);
            ldapsServer.start();
            this.apacheDS = new ApacheDS((DirectoryService)directoryService, ldapServer, ldapsServer);
        }
        if (install != null) {
            this.apacheDS.getDirectoryService().setWorkingDirectory(install.getPartitionsDirectory());
        }
        this.apacheDS.startup();
        if (this.apacheDS.getSynchPeriodMillis() > 0L) {
            this.workerThread = new Thread((Runnable)this.worker, "SynchWorkerThread");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    public DirectoryService getDirectoryService() {
        return this.apacheDS.getDirectoryService();
    }

    public void synch() throws Exception {
        this.apacheDS.getDirectoryService().sync();
    }

    public void start() {
        if (this.workerThread != null) {
            this.workerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String[] args) throws Exception {
        if (this.workerThread != null) {
            this.worker.stop = true;
            Object object = this.worker.lock;
            synchronized (object) {
                this.worker.lock.notify();
            }
            while (this.workerThread.isAlive()) {
                LOG.info("Waiting for SynchWorkerThread to die.");
                this.workerThread.join(500L);
            }
        }
        if (this.factory != null) {
            this.factory.close();
        }
        this.apacheDS.shutdown();
    }

    public void destroy() {
    }

    public static void printBanner() {
        System.out.println(BANNER);
    }

    class SynchWorker
    implements Runnable {
        final Object lock = new Object();
        boolean stop;

        SynchWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stop) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(Service.this.apacheDS.getSynchPeriodMillis());
                    }
                    catch (InterruptedException e) {
                        LOG.warn("SynchWorker failed to wait on lock.", (Throwable)e);
                    }
                }
                try {
                    Service.this.synch();
                }
                catch (Exception e) {
                    LOG.error("SynchWorker failed to synch directory.", (Throwable)e);
                }
            }
        }
    }
}

