/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server;

import java.io.File;
import org.apache.directory.daemon.DaemonApplication;
import org.apache.directory.daemon.InstallationLayout;
import org.apache.directory.server.changepw.ChangePasswordServer;
import org.apache.directory.server.configuration.ApacheDS;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.integration.http.HttpServer;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ntp.NtpServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.xbean.spring.context.FileSystemXmlApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service
implements DaemonApplication {
    private static final Logger LOG = LoggerFactory.getLogger(Service.class);
    private LdapServer ldapServer;
    private NtpServer ntpServer;
    private ChangePasswordServer changePwdServer;
    private KdcServer kdcServer;
    private ApacheDS apacheDS;
    private HttpServer httpServer;
    private FileSystemXmlApplicationContext factory;
    private static final String BANNER_LDAP = "           _                     _          ____  ____   \n          / \\   _ __    ___  ___| |__   ___|  _ \\/ ___|  \n         / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ | | \\___ \\  \n        / ___ \\| |_) | (_| | (__| | | |  __/ |_| |___) | \n       /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|____/|____/  \n               |_|                                       \n";
    private static final String BANNER_NTP = "           _                     _          _   _ _____ _ __    \n          / \\   _ __    ___  ___| |__   ___| \\ | |_  __| '_ \\   \n         / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ .\\| | | | | |_) |  \n        / ___ \\| |_) | (_| | (__| | | |  __/ |\\  | | | | .__/   \n       /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|_| \\_| |_| |_|      \n               |_|                                              \n";
    private static final String BANNER_KERBEROS = "           _                     _          _  __ ____   ___    \n          / \\   _ __    ___  ___| |__   ___| |/ /|  _ \\ / __|   \n         / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ ' / | | | / /      \n        / ___ \\| |_) | (_| | (__| | | |  __/ . \\ | |_| \\ \\__    \n       /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|_|\\_\\|____/ \\___|   \n               |_|                                              \n";
    private static final String BANNER_CHANGE_PWD = "         ___                              ___ __  __ __  ______    \n        / __|_       ___ _ __   ____  ___|  _ \\ \\ \\ / / / |  _ \\   \n       / /  | |__  / _` | '  \\ / ___\\/ _ \\ |_) \\ \\ / /\\/ /| | | |  \n       \\ \\__| '_  \\ (_| | |\\  | |___ | __/  __/ \\ ' /   / | |_| |  \n        \\___|_| |_|\\__,_|_| |_|\\__. |\\___| |     \\_/ \\_/  |____/   \n                                  |_|    |_|                       \n";

    public void init(InstallationLayout layout, String[] args) throws Exception {
        this.initLdap(layout, args);
        this.initNtp(layout, args);
        this.initChangePwd(layout, args);
        this.initKerberos(layout, args);
        this.initHttpServer();
    }

    private void initLdap(InstallationLayout layout, String[] args) throws Exception {
        LOG.info("Starting the LDAP server");
        Service.printBanner(BANNER_LDAP);
        long startTime = System.currentTimeMillis();
        if (args != null && args.length > 0 && new File(args[0]).exists()) {
            LOG.info("server: loading settings from ", (Object)args[0]);
            this.factory = new FileSystemXmlApplicationContext(new File(args[0]).toURI().toURL().toString());
            this.ldapServer = (LdapServer)this.factory.getBean("ldapServer");
            this.apacheDS = (ApacheDS)this.factory.getBean("apacheDS");
        } else {
            LOG.info("server: using default settings ...");
            DefaultDirectoryServiceFactory.DEFAULT.init("default");
            DirectoryService directoryService = DefaultDirectoryServiceFactory.DEFAULT.getDirectoryService();
            directoryService.startup();
            this.ldapServer = new LdapServer();
            this.ldapServer.setDirectoryService(directoryService);
            TcpTransport tcpTransportSsl = new TcpTransport(10636);
            tcpTransportSsl.enableSSL(true);
            this.ldapServer.setTransports(new Transport[]{new TcpTransport(10389), tcpTransportSsl});
            this.apacheDS = new ApacheDS(this.ldapServer);
        }
        if (layout != null) {
            this.ldapServer.getDirectoryService().setWorkingDirectory(layout.getPartitionsDirectory());
        }
        this.apacheDS.startup();
        if (LOG.isInfoEnabled()) {
            LOG.info("LDAP server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    private void initNtp(InstallationLayout layout, String[] args) throws Exception {
        if (this.factory == null) {
            return;
        }
        try {
            this.ntpServer = (NtpServer)this.factory.getBean("ntpServer");
        }
        catch (Exception e) {
            LOG.info("Cannot find any reference to the NTP Server in the server.xml file : the server won't be started");
            return;
        }
        System.out.println("Starting the NTP server");
        LOG.info("Starting the NTP server");
        Service.printBanner(BANNER_NTP);
        long startTime = System.currentTimeMillis();
        this.ntpServer.start();
        System.out.println("NTP Server started");
        if (LOG.isInfoEnabled()) {
            LOG.info("NTP server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    private void initKerberos(InstallationLayout layout, String[] args) throws Exception {
        if (this.factory == null) {
            return;
        }
        try {
            this.kdcServer = (KdcServer)this.factory.getBean("kdcServer");
        }
        catch (Exception e) {
            LOG.info("Cannot find any reference to the Kerberos Server in the server.xml file : the server won't be started");
            return;
        }
        System.out.println("Starting the Kerberos server");
        LOG.info("Starting the Kerberos server");
        Service.printBanner(BANNER_KERBEROS);
        long startTime = System.currentTimeMillis();
        this.kdcServer.start();
        System.out.println("Kerberos server started");
        if (LOG.isInfoEnabled()) {
            LOG.info("Kerberos server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    private void initChangePwd(InstallationLayout layout, String[] args) throws Exception {
        if (this.factory == null) {
            return;
        }
        try {
            this.changePwdServer = (ChangePasswordServer)this.factory.getBean("changePasswordServer");
        }
        catch (Exception e) {
            LOG.info("Cannot find any reference to the Change Password Server in the server.xml file : the server won't be started");
            return;
        }
        System.out.println("Starting the Change Password server");
        LOG.info("Starting the Change Password server");
        Service.printBanner(BANNER_CHANGE_PWD);
        long startTime = System.currentTimeMillis();
        this.changePwdServer.start();
        System.out.println("Change Password server started");
        if (LOG.isInfoEnabled()) {
            LOG.info("Change Password server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    private void initHttpServer() throws Exception {
        if (this.factory == null) {
            return;
        }
        try {
            this.httpServer = (HttpServer)this.factory.getBean("httpServer");
        }
        catch (Exception e) {
            LOG.info("Cannot find any reference to the HTTP Server in the server.xml file : the server won't be started");
            return;
        }
        if (this.httpServer != null) {
            this.httpServer.start();
        }
    }

    public DirectoryService getDirectoryService() {
        return this.ldapServer.getDirectoryService();
    }

    public void synch() throws Exception {
        this.ldapServer.getDirectoryService().sync();
    }

    public void start() {
        try {
            this.ldapServer.start();
        }
        catch (Exception e) {
            LOG.error("Cannot start the server : " + e.getMessage());
        }
    }

    public void stop(String[] args) throws Exception {
        if (this.factory != null) {
            this.factory.close();
        }
        this.ldapServer.stop();
        this.ldapServer.getDirectoryService().shutdown();
    }

    public void destroy() {
    }

    public static void printBanner(String bannerConstant) {
        System.out.println(bannerConstant);
    }
}

