/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jdbm.ActionRecordManager;
import jdbm.I18n;
import jdbm.RecordManager;
import jdbm.helper.ActionContext;
import jdbm.helper.ActionVersioning;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.EntryIO;
import jdbm.helper.LRUCache;
import jdbm.helper.Serializer;

public class SnapshotRecordManager
implements ActionRecordManager {
    protected RecordManager recordManager;
    private static final ThreadLocal<ActionContext> actionContextVar = new ThreadLocal<ActionContext>(){

        @Override
        protected ActionContext initialValue() {
            return null;
        }
    };
    ActionVersioning versioning = new ActionVersioning();
    LRUCache<Long, Object> versionedCache;
    RecordIO recordIO = new RecordIO();
    Lock bigLock = new ReentrantLock();

    public SnapshotRecordManager(RecordManager recordManager, int size) {
        if (recordManager == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_517, new Object[0]));
        }
        this.recordManager = recordManager;
        this.versionedCache = new LRUCache<Long, Object>(this.recordIO, size);
    }

    @Override
    public ActionContext beginAction(boolean readOnly, String whoStarted) {
        ActionVersioning.Version version;
        ActionContext actionContext = new ActionContext();
        if (readOnly) {
            version = this.versioning.beginReadAction();
        } else {
            this.bigLock.lock();
            version = this.versioning.beginWriteAction();
        }
        actionContext.beginAction(readOnly, version, whoStarted);
        this.setCurrentActionContext(actionContext);
        return actionContext;
    }

    @Override
    public void setCurrentActionContext(ActionContext context) {
        ActionContext actionContext = actionContextVar.get();
        if (actionContext != null) {
            throw new IllegalStateException("Action Context Not Null: " + actionContext.getWhoStarted());
        }
        actionContextVar.set(context);
    }

    @Override
    public void unsetCurrentActionContext(ActionContext context) {
        ActionContext actionContext = actionContextVar.get();
        if (actionContext != context) {
            throw new IllegalStateException("Trying to end action context not set in the thread context variable" + context + " " + actionContext);
        }
        actionContextVar.set(null);
    }

    @Override
    public void endAction(ActionContext actionContext) {
        ActionVersioning.Version minVersion = null;
        if (actionContext.isReadOnlyAction()) {
            ActionVersioning.Version version = actionContext.getVersion();
            minVersion = this.versioning.endReadAction(version);
            actionContext.endAction();
        } else if (actionContext.isWriteAction()) {
            minVersion = this.versioning.endWriteAction();
            actionContext.endAction();
            this.bigLock.unlock();
        } else {
            throw new IllegalStateException(" Wrong action type " + actionContext);
        }
        this.unsetCurrentActionContext(actionContext);
        if (minVersion != null) {
            this.versionedCache.advanceMinReadVersion(minVersion.getVersion());
        }
    }

    @Override
    public void abortAction(ActionContext actionContext) {
        ActionVersioning.Version minVersion = null;
        if (actionContext.isReadOnlyAction()) {
            ActionVersioning.Version version = actionContext.getVersion();
            minVersion = this.versioning.endReadAction(version);
            actionContext.endAction();
        } else if (actionContext.isWriteAction()) {
            actionContext.endAction();
            this.bigLock.unlock();
        } else {
            throw new IllegalStateException("Wrong action context type " + actionContext);
        }
        this.unsetCurrentActionContext(actionContext);
        if (minVersion != null) {
            this.versionedCache.advanceMinReadVersion(minVersion.getVersion());
        }
    }

    public RecordManager getRecordManager() {
        return this.recordManager;
    }

    @Override
    public long insert(Object obj) throws IOException {
        return this.insert(obj, DefaultSerializer.INSTANCE);
    }

    @Override
    public long insert(Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        ActionContext actionContext = actionContextVar.get();
        boolean startedAction = false;
        boolean abortedAction = false;
        if (actionContext == null) {
            actionContext = this.beginAction(false, "insert missing action");
            startedAction = true;
        }
        long recid = 0L;
        try {
            recid = this.recordManager.insert(obj, serializer);
            this.versionedCache.put(recid, obj, actionContext.getVersion().getVersion(), serializer, false);
        }
        catch (IOException e) {
            if (startedAction) {
                this.abortAction(actionContext);
                abortedAction = true;
            }
            throw e;
        }
        catch (CacheEvictionException except) {
            if (startedAction) {
                this.abortAction(actionContext);
                abortedAction = true;
            }
            throw new IOException(except.getLocalizedMessage());
        }
        finally {
            if (startedAction && !abortedAction) {
                this.endAction(actionContext);
            }
        }
        return recid;
    }

    @Override
    public void delete(long recid) throws IOException {
        this.checkIfClosed();
        ActionContext actionContext = actionContextVar.get();
        boolean startedAction = false;
        boolean abortedAction = false;
        if (actionContext == null) {
            actionContext = this.beginAction(false, "delete missing action");
            startedAction = true;
        }
        try {
            this.versionedCache.put(recid, null, actionContext.getVersion().getVersion(), null, false);
        }
        catch (IOException e) {
            if (startedAction) {
                this.abortAction(actionContext);
                abortedAction = true;
            }
            throw e;
        }
        catch (CacheEvictionException except) {
            if (startedAction) {
                this.abortAction(actionContext);
                abortedAction = true;
            }
            throw new IOException(except.getLocalizedMessage());
        }
        finally {
            if (startedAction && !abortedAction) {
                this.endAction(actionContext);
            }
        }
    }

    @Override
    public void update(long recid, Object obj) throws IOException {
        this.update(recid, obj, DefaultSerializer.INSTANCE);
    }

    @Override
    public void update(long recid, Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        ActionContext actionContext = actionContextVar.get();
        boolean startedAction = false;
        boolean abortedAction = false;
        if (actionContext == null) {
            actionContext = this.beginAction(false, "update missing action");
            startedAction = true;
        }
        try {
            this.versionedCache.put(recid, obj, actionContext.getVersion().getVersion(), serializer, recid < 0L);
        }
        catch (IOException e) {
            if (startedAction) {
                this.abortAction(actionContext);
                abortedAction = true;
            }
            throw e;
        }
        catch (CacheEvictionException except) {
            if (startedAction) {
                this.abortAction(actionContext);
                abortedAction = true;
            }
            throw new IOException(except.getLocalizedMessage());
        }
        finally {
            if (startedAction && !abortedAction) {
                this.endAction(actionContext);
            }
        }
    }

    @Override
    public Object fetch(long recid) throws IOException {
        return this.fetch(recid, DefaultSerializer.INSTANCE);
    }

    @Override
    public Object fetch(long recid, Serializer serializer) throws IOException {
        Object obj;
        this.checkIfClosed();
        ActionContext actionContext = actionContextVar.get();
        boolean startedAction = false;
        boolean abortedAction = false;
        if (actionContext == null) {
            actionContext = this.beginAction(false, "fetch missing action");
            startedAction = true;
        }
        try {
            obj = this.versionedCache.get(recid, actionContext.getVersion().getVersion(), serializer);
        }
        catch (IOException e) {
            if (startedAction) {
                this.abortAction(actionContext);
                abortedAction = true;
            }
            throw e;
        }
        finally {
            if (startedAction && !abortedAction) {
                this.endAction(actionContext);
            }
        }
        return obj;
    }

    @Override
    public void close() throws IOException {
        this.checkIfClosed();
        this.recordManager.close();
        this.recordManager = null;
        this.versionedCache = null;
        this.versioning = null;
    }

    @Override
    public int getRootCount() {
        this.checkIfClosed();
        return this.recordManager.getRootCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRoot(int id) throws IOException {
        this.bigLock.lock();
        try {
            this.checkIfClosed();
            long l = this.recordManager.getRoot(id);
            return l;
        }
        finally {
            this.bigLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRoot(int id, long rowid) throws IOException {
        this.bigLock.lock();
        try {
            this.checkIfClosed();
            this.recordManager.setRoot(id, rowid);
        }
        finally {
            this.bigLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        this.bigLock.lock();
        try {
            this.checkIfClosed();
            this.recordManager.commit();
        }
        finally {
            this.bigLock.unlock();
        }
    }

    @Override
    public void rollback() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNamedObject(String name) throws IOException {
        this.bigLock.lock();
        try {
            this.checkIfClosed();
            long l = this.recordManager.getNamedObject(name);
            return l;
        }
        finally {
            this.bigLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNamedObject(String name, long recid) throws IOException {
        this.bigLock.lock();
        try {
            this.checkIfClosed();
            this.recordManager.setNamedObject(name, recid);
        }
        finally {
            this.bigLock.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SnapshotRecordManager: ");
        sb.append("(lruCache:").append(this.versionedCache);
        sb.append(")\n");
        return sb.toString();
    }

    private void checkIfClosed() throws IllegalStateException {
        if (this.recordManager == null) {
            throw new IllegalStateException(I18n.err(I18n.ERR_538, new Object[0]));
        }
    }

    private class RecordIO
    implements EntryIO<Long, Object> {
        private RecordIO() {
        }

        @Override
        public Object read(Long key, Serializer serializer) throws IOException {
            if (key < 0L) {
                return null;
            }
            return SnapshotRecordManager.this.recordManager.fetch(key, serializer);
        }

        @Override
        public void write(Long key, Object value, Serializer serializer) throws IOException {
            if (key < 0L) {
                return;
            }
            if (value != null) {
                SnapshotRecordManager.this.recordManager.update(key, value, serializer);
            } else {
                SnapshotRecordManager.this.recordManager.delete(key);
            }
        }
    }
}

