/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import jdbm.recman.BlockIo;
import jdbm.recman.TransactionManager;
import org.apache.directory.server.i18n.I18n;

public final class RecordFile {
    private TransactionManager transactionManager;
    private final LinkedList<BlockIo> free = new LinkedList();
    private final HashMap<Long, BlockIo> inUse = new HashMap();
    private final HashMap<Long, BlockIo> dirty = new HashMap();
    private final HashMap<Long, BlockIo> inTxn = new HashMap();
    private boolean transactionsDisabled = false;
    public static final int BLOCK_SIZE = 4096;
    static final String EXTENSION = ".db";
    static final byte[] cleanData = new byte[4096];
    private RandomAccessFile file;
    private final String fileName;

    RecordFile(String fileName) throws IOException {
        this.fileName = fileName;
        this.file = new RandomAccessFile(fileName + EXTENSION, "rw");
    }

    TransactionManager getTxnMgr() throws IOException {
        if (this.transactionsDisabled) {
            throw new IllegalStateException("Transactions are disabled.");
        }
        if (this.transactionManager == null) {
            this.transactionManager = new TransactionManager(this);
        }
        return this.transactionManager;
    }

    String getFileName() {
        return this.fileName;
    }

    void disableTransactions() {
        this.transactionsDisabled = true;
    }

    BlockIo get(long blockId) throws IOException {
        BlockIo blockIo = this.inTxn.get(blockId);
        if (blockIo != null) {
            this.inTxn.remove(blockId);
            this.inUse.put(blockId, blockIo);
            return blockIo;
        }
        blockIo = this.dirty.get(blockId);
        if (blockIo != null) {
            this.dirty.remove(blockId);
            this.inUse.put(blockId, blockIo);
            return blockIo;
        }
        Iterator iterator = this.free.iterator();
        while (iterator.hasNext()) {
            BlockIo cur = (BlockIo)iterator.next();
            if (cur.getBlockId() != blockId) continue;
            blockIo = cur;
            iterator.remove();
            this.inUse.put(blockId, blockIo);
            return blockIo;
        }
        if (this.inUse.get(blockId) != null) {
            throw new Error(I18n.err((I18n)I18n.ERR_554, (Object[])new Object[]{blockId}));
        }
        blockIo = this.getNewBlockIo(blockId);
        long offset = blockId * 4096L;
        long fileLength = this.file.length();
        if (fileLength > 0L && offset <= fileLength) {
            RecordFile.read(this.file, offset, blockIo.getData(), 4096);
        }
        this.inUse.put(blockId, blockIo);
        blockIo.setClean();
        return blockIo;
    }

    void release(long blockId, boolean isDirty) throws IOException {
        BlockIo blockIo = this.inUse.get(blockId);
        if (blockIo == null) {
            throw new IOException(I18n.err((I18n)I18n.ERR_555, (Object[])new Object[]{blockId}));
        }
        if (!blockIo.isDirty() && isDirty) {
            blockIo.setDirty();
        }
        this.release(blockIo);
    }

    void release(BlockIo block) {
        this.inUse.remove(block.getBlockId());
        if (block.isDirty()) {
            this.dirty.put(block.getBlockId(), block);
        } else if (!this.transactionsDisabled && block.isInTransaction()) {
            this.inTxn.put(block.getBlockId(), block);
        } else {
            this.free.add(block);
        }
    }

    void discard(BlockIo block) {
        this.inUse.remove(block.getBlockId());
    }

    void commit() throws IOException {
        if (!this.inUse.isEmpty() && this.inUse.size() > 1) {
            this.showList(this.inUse.values().iterator());
            throw new Error(I18n.err((I18n)I18n.ERR_556, (Object[])new Object[]{this.inUse.size()}));
        }
        if (this.dirty.size() == 0) {
            return;
        }
        if (!this.transactionsDisabled) {
            this.getTxnMgr().start();
        }
        for (BlockIo blockIo : this.dirty.values()) {
            if (this.transactionsDisabled) {
                this.sync(blockIo);
                blockIo.setClean();
                this.free.add(blockIo);
                continue;
            }
            this.getTxnMgr().add(blockIo);
            this.inTxn.put(blockIo.getBlockId(), blockIo);
        }
        this.dirty.clear();
        if (!this.transactionsDisabled) {
            this.getTxnMgr().commit();
        }
    }

    void rollback() throws IOException {
        if (!this.inUse.isEmpty()) {
            this.showList(this.inUse.values().iterator());
            throw new Error(I18n.err((I18n)I18n.ERR_557, (Object[])new Object[]{this.inUse.size()}));
        }
        this.dirty.clear();
        if (!this.transactionsDisabled) {
            this.getTxnMgr().synchronizeLogFromDisk();
        }
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.values().iterator());
            throw new Error(I18n.err((I18n)I18n.ERR_558, (Object[])new Object[]{this.inTxn.size()}));
        }
    }

    void close() throws IOException {
        if (!this.dirty.isEmpty()) {
            this.commit();
        }
        if (!this.transactionsDisabled) {
            this.getTxnMgr().shutdown();
        }
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.values().iterator());
            throw new Error(I18n.err((I18n)I18n.ERR_559, (Object[])new Object[0]));
        }
        if (!this.dirty.isEmpty()) {
            System.out.println("ERROR: dirty blocks at close time");
            this.showList(this.dirty.values().iterator());
            throw new Error(I18n.err((I18n)I18n.ERR_560, (Object[])new Object[0]));
        }
        if (!this.inUse.isEmpty()) {
            System.out.println("ERROR: inUse blocks at close time");
            this.showList(this.inUse.values().iterator());
            throw new Error(I18n.err((I18n)I18n.ERR_561, (Object[])new Object[0]));
        }
        this.file.close();
        this.file = null;
    }

    void forceClose() throws IOException {
        if (!this.transactionsDisabled) {
            this.getTxnMgr().forceClose();
        }
        this.file.close();
    }

    private void showList(Iterator<BlockIo> i) {
        int cnt = 0;
        while (i.hasNext()) {
            System.out.println("elem " + cnt + ": " + i.next());
            ++cnt;
        }
    }

    private BlockIo getNewBlockIo(long blockId) throws IOException {
        BlockIo blockIo = null;
        if (!this.free.isEmpty()) {
            blockIo = this.free.removeFirst();
            blockIo.setBlockId(blockId);
        }
        if (blockIo == null) {
            blockIo = new BlockIo(blockId, new byte[4096]);
        }
        blockIo.setView(null);
        return blockIo;
    }

    void sync(BlockIo blockIo) throws IOException {
        byte[] data = blockIo.getData();
        if (data != null) {
            long offset = blockIo.getBlockId() * 4096L;
            this.file.seek(offset);
            this.file.write(data);
        }
    }

    void releaseFromTransaction(BlockIo node, boolean recycle) throws IOException {
        if (this.inTxn.remove(node.getBlockId()) != null && recycle) {
            this.free.add(node);
        }
    }

    void sync() throws IOException {
        this.file.getFD().sync();
    }

    private static void read(RandomAccessFile file, long offset, byte[] buffer, int nBytes) throws IOException {
        file.seek(offset);
        int remaining = nBytes;
        int pos = 0;
        while (remaining > 0) {
            int read = file.read(buffer, pos, remaining);
            if (read == -1) {
                System.arraycopy(cleanData, 0, buffer, pos, remaining);
                break;
            }
            remaining -= read;
            pos += read;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RecordFile<").append(this.fileName).append(", ");
        sb.append("size : ");
        try {
            sb.append(this.file.length()).append("bytes");
        }
        catch (IOException ioe) {
            sb.append("unknown");
        }
        if (this.transactionsDisabled) {
            sb.append("(noTx)");
        } else {
            sb.append("(Tx)");
        }
        sb.append("\n    Free blockIo : ").append(this.free.size());
        for (BlockIo blockIo : this.free) {
            sb.append("\n         ");
            sb.append(blockIo);
        }
        sb.append("\n    InUse blockIo : ").append(this.inUse.size());
        for (BlockIo blockIo : this.inUse.values()) {
            sb.append("\n         ");
            sb.append(blockIo);
        }
        sb.append("\n    Dirty blockIo : ").append(this.dirty.size());
        for (BlockIo blockIo : this.dirty.values()) {
            sb.append("\n         ");
            sb.append(blockIo);
        }
        sb.append("\n    InTxn blockIo : ").append(this.inTxn.size());
        for (BlockIo blockIo : this.inTxn.values()) {
            sb.append("\n         ");
            sb.append(blockIo);
        }
        return sb.toString();
    }
}

