/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.kerberos.kdc.AbstractKerberosITest;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.crypto.checksum.ChecksumType;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="KerberosKRBProtocolTest-class", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com")}, additionalInterceptors={KeyDerivationInterceptor.class})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@CreateKdcServer(transports={@CreateTransport(protocol="KRB")})
@ApplyLdifFiles(value={"org/apache/directory/server/kerberos/kdc/KerberosIT.ldif"})
public class KerberosKRBProtocolTest
extends AbstractKerberosITest {
    @Test
    public void testObtainTickets_AES128_TCP() throws Exception {
        AbstractKerberosITest.ObtainTicketParameters parameters = new AbstractKerberosITest.ObtainTicketParameters(this, TcpTransport.class, EncryptionType.AES128_CTS_HMAC_SHA1_96, ChecksumType.HMAC_SHA1_96_AES128);
        this.testObtainTickets(parameters);
    }

    @Test
    public void testObtainTickets_AES128_UDP() throws Exception {
        AbstractKerberosITest.ObtainTicketParameters parameters = new AbstractKerberosITest.ObtainTicketParameters(this, UdpTransport.class, EncryptionType.AES128_CTS_HMAC_SHA1_96, ChecksumType.HMAC_SHA1_96_AES128);
        this.testObtainTickets(parameters);
    }
}

