/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import java.io.BufferedInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Network;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.Krb5LoginConfiguration;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KerberosUdpITest;
import org.apache.directory.server.ldap.LdapServer;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosTestUtils {
    public static final String[] hex_digit = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static char[] getControlDocument(String resource) throws IOException {
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(resource);
        CharArrayWriter writer = new CharArrayWriter();
        try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(is));){
            char[] buf = new char[2048];
            int len = 0;
            while (len >= 0) {
                len = reader.read(buf);
                if (len <= 0) continue;
                writer.write(buf, 0, len);
            }
        }
        char[] isca = writer.toCharArray();
        return isca;
    }

    public static byte[] getBytesFromResource(String resource) throws IOException {
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(resource);
        try (BufferedInputStream stream = new BufferedInputStream(is);){
            int len = stream.available();
            byte[] bytes = new byte[len];
            stream.read(bytes, 0, len);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public static void hexdump(byte[] data) {
        KerberosTestUtils.hexdump(data, true);
    }

    public static void hexdump(byte[] data, boolean delimit) {
        String delimiter = new String("-------------------------------------------------");
        if (delimit) {
            System.out.println(delimiter);
        }
        int lineLength = 0;
        for (int ii = 0; ii < data.length; ++ii) {
            System.out.print(KerberosTestUtils.byte2hexString(data[ii]) + " ");
            if (++lineLength == 8) {
                System.out.print("  ");
            }
            if (lineLength != 16) continue;
            System.out.println();
            lineLength = 0;
        }
        if (delimit) {
            System.out.println();
            System.out.println(delimiter);
        }
    }

    public static String byte2hexString(byte x) {
        String s = "";
        for (int ii = 0; ii < 2; ++ii) {
            s = hex_digit[(x & 0xFF & 15 << ii * 4) >>> ii * 4] + s;
        }
        return s;
    }

    public static String int2hexString(int x) {
        String s = "";
        for (int ii = 0; ii < 8; ++ii) {
            s = hex_digit[(x & 15 << ii * 4) >>> ii * 4] + s;
        }
        return s;
    }

    public static String int2binString(int x) {
        String s = "";
        for (int ii = 0; ii < 32; ++ii) {
            if (ii > 0 && ii % 4 == 0) {
                s = " " + s;
            }
            s = hex_digit[(x & 1 << ii) >>> ii] + s;
        }
        return s;
    }

    public static String long2hexString(long x) {
        String s = "";
        for (int ii = 0; ii < 16; ++ii) {
            s = hex_digit[(int)((x & 15L << ii * 4) >>> ii * 4)] + s;
        }
        return s;
    }

    public static String long2binString(long x) {
        String s = "";
        for (int ii = 0; ii < 64; ++ii) {
            if (ii > 0 && ii % 4 == 0) {
                s = " " + s;
            }
            s = hex_digit[(int)((x & 1L << ii) >>> ii)] + s;
        }
        return s;
    }

    public static String byte2hexString(byte[] input) {
        return KerberosTestUtils.byte2hexString(input, 0, input.length);
    }

    public static String byte2hexString(byte[] input, int offset) {
        return KerberosTestUtils.byte2hexString(input, offset, input.length);
    }

    public static String byte2hexString(byte[] input, int offset, int length) {
        String result = "";
        for (int ii = 0; ii < length; ++ii) {
            if (ii + offset >= input.length) continue;
            result = result + KerberosTestUtils.byte2hexString(input[ii + offset]);
        }
        return result;
    }

    public static String getHostName() {
        return Network.LOOPBACK_HOSTNAME;
    }

    public static void obtainTGT(Subject subject, String userName, String password) throws LoginException {
        Configuration.setConfiguration((Configuration)new Krb5LoginConfiguration());
        LoginContext lc = new LoginContext(KerberosUdpITest.class.getName(), subject, new CallbackHandlerBean(userName, password));
        lc.login();
    }

    public static void obtainServiceTickets(Subject subject, String userName, String serviceName, String hostName) throws GSSException {
        ObtainServiceTicketAction action = new ObtainServiceTicketAction(userName, serviceName, hostName);
        GSSException exception = Subject.doAs(subject, action);
        if (exception != null) {
            throw exception;
        }
    }

    public static String fixServicePrincipalName(String servicePrincipalName, Dn serviceEntryDn, LdapServer ldapServer) throws LdapException {
        KerberosPrincipal servicePrincipal = new KerberosPrincipal(servicePrincipalName, 3);
        servicePrincipalName = servicePrincipal.getName();
        ldapServer.setSaslHost(servicePrincipalName.substring(servicePrincipalName.indexOf("/") + 1, servicePrincipalName.indexOf("@")));
        ldapServer.setSaslPrincipal(servicePrincipalName);
        if (serviceEntryDn != null) {
            ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
            modifyRequest.setName(serviceEntryDn);
            modifyRequest.replace("userPassword", new String[]{"randall"});
            modifyRequest.replace("krb5PrincipalName", new String[]{servicePrincipalName});
            ldapServer.getDirectoryService().getAdminSession().modify((ModifyRequest)modifyRequest);
        }
        return servicePrincipalName;
    }

    private static class ObtainServiceTicketAction
    implements PrivilegedAction<GSSException> {
        private String userName;
        private String serviceName;
        private String hostName;

        public ObtainServiceTicketAction(String userName, String serviceName, String hostName) {
            this.userName = userName;
            this.serviceName = serviceName;
            this.hostName = hostName;
        }

        @Override
        public GSSException run() {
            try {
                GSSManager manager = GSSManager.getInstance();
                GSSName clientName = manager.createName(this.userName, GSSName.NT_USER_NAME);
                GSSCredential clientCred = manager.createCredential(clientName, 28800, this.createKerberosOid(), 1);
                GSSName serverName = manager.createName(this.serviceName + "@" + this.hostName, GSSName.NT_HOSTBASED_SERVICE);
                GSSContext context = manager.createContext(serverName, this.createKerberosOid(), clientCred, 0);
                context.requestMutualAuth(true);
                context.requestConf(true);
                context.requestInteg(true);
                context.initSecContext(Strings.EMPTY_BYTES, 0, 0);
                context.dispose();
                return null;
            }
            catch (GSSException gsse) {
                return gsse;
            }
        }

        private Oid createKerberosOid() throws GSSException {
            return new Oid("1.2.840.113554.1.2.2");
        }
    }

    private static class CallbackHandlerBean
    implements CallbackHandler {
        private String name;
        private String password;

        public CallbackHandlerBean(String name, String password) {
            this.name = name;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(this.name);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    passwordCallback.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, I18n.err((I18n)I18n.ERR_617, (Object[])new Object[0]));
            }
        }
    }
}

