/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import java.util.ArrayList;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;

public class KdcConfiguration
extends ServiceConfiguration {
    private static final long serialVersionUID = 522567370475574165L;
    private static final int DEFAULT_IP_PORT = 88;
    public static final String DEFAULT_SEARCH_BASEDN = "ou=users,dc=example,dc=com";
    private static final String DEFAULT_PID = "org.apache.directory.server.kerberos";
    private static final String DEFAULT_NAME = "ApacheDS Kerberos Service";
    private static final String DEFAULT_PRINCIPAL = "krbtgt/EXAMPLE.COM@EXAMPLE.COM";
    private static final String DEFAULT_REALM = "EXAMPLE.COM";
    private static final long DEFAULT_ALLOWABLE_CLOCKSKEW = 300000L;
    private static final String[] DEFAULT_ENCRYPTION_TYPES = new String[]{"des-cbc-md5"};
    private static final boolean DEFAULT_EMPTY_ADDRESSES_ALLOWED = true;
    private static final boolean DEFAULT_PA_ENC_TIMESTAMP_REQUIRED = true;
    private static final int DEFAULT_TGS_MAXIMUM_TICKET_LIFETIME = 86400000;
    private static final int DEFAULT_TGS_MAXIMUM_RENEWABLE_LIFETIME = 604800000;
    private static final boolean DEFAULT_TGS_FORWARDABLE_ALLOWED = true;
    private static final boolean DEFAULT_TGS_PROXIABLE_ALLOWED = true;
    private static final boolean DEFAULT_TGS_POSTDATED_ALLOWED = true;
    private static final boolean DEFAULT_TGS_RENEWABLE_ALLOWED = true;
    private static final boolean DEFAULT_VERIFY_BODY_CHECKSUM = true;
    private EncryptionType[] encryptionTypes;
    private String primaryRealm = "EXAMPLE.COM";
    private String servicePrincipal = "krbtgt/EXAMPLE.COM@EXAMPLE.COM";
    private long allowableClockSkew = 300000L;
    private boolean isPaEncTimestampRequired = true;
    private long maximumTicketLifetime = 86400000L;
    private long maximumRenewableLifetime = 604800000L;
    private boolean isEmptyAddressesAllowed = true;
    private boolean isForwardableAllowed = true;
    private boolean isProxiableAllowed = true;
    private boolean isPostdatedAllowed = true;
    private boolean isRenewableAllowed = true;
    private boolean isBodyChecksumVerified = true;

    public KdcConfiguration() {
        super.setServiceName(DEFAULT_NAME);
        super.setIpPort(88);
        super.setServicePid(DEFAULT_PID);
        super.setSearchBaseDn(DEFAULT_SEARCH_BASEDN);
        this.prepareEncryptionTypes();
    }

    public long getAllowableClockSkew() {
        return this.allowableClockSkew;
    }

    public boolean isEmptyAddressesAllowed() {
        return this.isEmptyAddressesAllowed;
    }

    public boolean isForwardableAllowed() {
        return this.isForwardableAllowed;
    }

    public boolean isPostdatedAllowed() {
        return this.isPostdatedAllowed;
    }

    public boolean isProxiableAllowed() {
        return this.isProxiableAllowed;
    }

    public boolean isRenewableAllowed() {
        return this.isRenewableAllowed;
    }

    public long getMaximumRenewableLifetime() {
        return this.maximumRenewableLifetime;
    }

    public long getMaximumTicketLifetime() {
        return this.maximumTicketLifetime;
    }

    public void setAllowableClockSkew(long allowableClockSkew) {
        this.allowableClockSkew = allowableClockSkew;
    }

    public void setEncryptionTypes(EncryptionType[] encryptionTypes) {
        this.encryptionTypes = encryptionTypes;
    }

    public void setEmptyAddressesAllowed(boolean isEmptyAddressesAllowed) {
        this.isEmptyAddressesAllowed = isEmptyAddressesAllowed;
    }

    public void setForwardableAllowed(boolean isForwardableAllowed) {
        this.isForwardableAllowed = isForwardableAllowed;
    }

    public void setPaEncTimestampRequired(boolean isPaEncTimestampRequired) {
        this.isPaEncTimestampRequired = isPaEncTimestampRequired;
    }

    public void setPostdatedAllowed(boolean isPostdatedAllowed) {
        this.isPostdatedAllowed = isPostdatedAllowed;
    }

    public void setProxiableAllowed(boolean isProxiableAllowed) {
        this.isProxiableAllowed = isProxiableAllowed;
    }

    public void setRenewableAllowed(boolean isRenewableAllowed) {
        this.isRenewableAllowed = isRenewableAllowed;
    }

    public void setKdcPrincipal(String kdcPrincipal) {
        this.servicePrincipal = kdcPrincipal;
    }

    public void setMaximumRenewableLifetime(long maximumRenewableLifetime) {
        this.maximumRenewableLifetime = maximumRenewableLifetime;
    }

    public void setMaximumTicketLifetime(long maximumTicketLifetime) {
        this.maximumTicketLifetime = maximumTicketLifetime;
    }

    public void setPrimaryRealm(String primaryRealm) {
        this.primaryRealm = primaryRealm;
    }

    public String getPrimaryRealm() {
        return this.primaryRealm;
    }

    public KerberosPrincipal getServicePrincipal() {
        return new KerberosPrincipal(this.servicePrincipal);
    }

    public EncryptionType[] getEncryptionTypes() {
        return this.encryptionTypes;
    }

    public boolean isPaEncTimestampRequired() {
        return this.isPaEncTimestampRequired;
    }

    public boolean isBodyChecksumVerified() {
        return this.isBodyChecksumVerified;
    }

    public void setBodyChecksumVerified(boolean isBodyChecksumVerified) {
        this.isBodyChecksumVerified = isBodyChecksumVerified;
    }

    private void prepareEncryptionTypes() {
        String[] encryptionTypeStrings = DEFAULT_ENCRYPTION_TYPES;
        ArrayList<EncryptionType> encTypes = new ArrayList<EncryptionType>();
        for (String enc : encryptionTypeStrings) {
            for (EncryptionType type : EncryptionType.VALUES) {
                if (!type.getName().equalsIgnoreCase(enc)) continue;
                encTypes.add(type);
            }
        }
        this.encryptionTypes = encTypes.toArray(new EncryptionType[encTypes.size()]);
    }
}

