/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import org.apache.directory.server.kerberos.kdc.KdcContext;
import org.apache.directory.server.kerberos.shared.messages.KdcReply;
import org.apache.directory.server.kerberos.shared.messages.KerberosMessage;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorReply
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(MonitorReply.class);
    private String serviceName;
    private String contextKey = "context";

    public MonitorReply(String serviceName) {
        this.serviceName = serviceName;
    }

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        KdcContext kdcContext = (KdcContext)session.getAttribute(this.getContextKey());
        KerberosMessage reply = kdcContext.getReply();
        if (log.isDebugEnabled() && reply instanceof KdcReply) {
            KdcReply success = (KdcReply)reply;
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("Responding with " + this.serviceName + " reply:");
                sb.append("\n\tmessageType:           " + success.getMessageType());
                sb.append("\n\tprotocolVersionNumber: " + success.getProtocolVersionNumber());
                sb.append("\n\tnonce:                 " + success.getNonce());
                sb.append("\n\tclientPrincipal:       " + success.getClientPrincipal());
                sb.append("\n\tclient realm:          " + success.getClientRealm());
                sb.append("\n\tserverPrincipal:       " + success.getServerPrincipal());
                sb.append("\n\tserver realm:          " + success.getServerRealm());
                sb.append("\n\tauth time:             " + success.getAuthTime());
                sb.append("\n\tstart time:            " + success.getStartTime());
                sb.append("\n\tend time:              " + success.getEndTime());
                sb.append("\n\trenew-till time:       " + success.getRenewTill());
                sb.append("\n\thostAddresses:         " + success.getClientAddresses());
                log.debug(sb.toString());
            }
            catch (Exception e) {
                log.error("Error in reply monitor", (Throwable)e);
            }
        }
        next.execute(session, message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

