/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import org.apache.directory.server.kerberos.kdc.KdcContext;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorRequest
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(MonitorRequest.class);
    private String serviceName;
    private String contextKey = "context";

    public MonitorRequest(String serviceName) {
        this.serviceName = serviceName;
    }

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        KdcContext kdcContext = (KdcContext)session.getAttribute(this.getContextKey());
        KdcRequest request = kdcContext.getRequest();
        if (log.isDebugEnabled()) {
            try {
                String clientAddress = kdcContext.getClientAddress().getHostAddress();
                StringBuffer sb = new StringBuffer();
                sb.append("Received " + this.serviceName + " request:");
                sb.append("\n\tmessageType:           " + request.getMessageType());
                sb.append("\n\tprotocolVersionNumber: " + request.getProtocolVersionNumber());
                sb.append("\n\tclientAddress:         " + clientAddress);
                sb.append("\n\tnonce:                 " + request.getNonce());
                sb.append("\n\tkdcOptions:            " + request.getKdcOptions());
                sb.append("\n\tclientPrincipal:       " + request.getClientPrincipal());
                sb.append("\n\tserverPrincipal:       " + request.getServerPrincipal());
                sb.append("\n\tencryptionType:        " + this.getEncryptionTypes(request));
                sb.append("\n\trealm:                 " + request.getRealm());
                sb.append("\n\tfrom time:             " + request.getFrom());
                sb.append("\n\ttill time:             " + request.getTill());
                sb.append("\n\trenew-till time:       " + request.getRtime());
                sb.append("\n\thostAddresses:         " + request.getAddresses());
                log.debug(sb.toString());
            }
            catch (Exception e) {
                log.error("Error in request monitor", (Throwable)e);
            }
        }
        next.execute(session, message);
    }

    protected String getEncryptionTypes(KdcRequest request) {
        EncryptionType[] etypes = request.getEType();
        StringBuffer sb = new StringBuffer();
        for (int ii = 0; ii < etypes.length; ++ii) {
            sb.append(etypes[ii].toString());
            if (ii >= etypes.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

