/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.authentication;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.crypto.encryption.RandomKeyFactory;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPartModifier;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.TransitedEncoding;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateTicket
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(GenerateTicket.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        AuthenticationContext authContext = (AuthenticationContext)session.getAttribute(this.getContextKey());
        KdcRequest request = authContext.getRequest();
        CipherTextHandler cipherTextHandler = authContext.getCipherTextHandler();
        KerberosPrincipal serverPrincipal = request.getServerPrincipal();
        EncryptionType encryptionType = authContext.getEncryptionType();
        EncryptionKey serverKey = (EncryptionKey)authContext.getServerEntry().getKeyMap().get(encryptionType);
        KerberosPrincipal ticketPrincipal = request.getServerPrincipal();
        EncTicketPartModifier newTicketBody = new EncTicketPartModifier();
        KdcConfiguration config = authContext.getConfig();
        newTicketBody.setFlag(9);
        if (authContext.isPreAuthenticated()) {
            newTicketBody.setFlag(10);
        }
        if (request.getOption(1)) {
            if (!config.isForwardableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag(1);
        }
        if (request.getOption(3)) {
            if (!config.isProxiableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag(3);
        }
        if (request.getOption(5)) {
            if (!config.isPostdatedAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag(5);
        }
        if (request.getOption(30) || request.getOption(31) || request.getOption(4) || request.getOption(2) || request.getOption(28)) {
            throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
        }
        EncryptionKey sessionKey = RandomKeyFactory.getRandomKey((EncryptionType)authContext.getEncryptionType());
        newTicketBody.setSessionKey(sessionKey);
        newTicketBody.setClientPrincipal(request.getClientPrincipal());
        newTicketBody.setTransitedEncoding(new TransitedEncoding());
        KerberosTime now = new KerberosTime();
        newTicketBody.setAuthTime(now);
        KerberosTime startTime = request.getFrom();
        if (startTime == null || startTime.lessThan(now) || startTime.isInClockSkew(config.getAllowableClockSkew()) && !request.getOption(6)) {
            startTime = now;
        }
        if (startTime != null && startTime.greaterThan(now) && !startTime.isInClockSkew(config.getAllowableClockSkew()) && !request.getOption(6)) {
            throw new KerberosException(ErrorType.KDC_ERR_CANNOT_POSTDATE);
        }
        if (request.getOption(6)) {
            if (!config.isPostdatedAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag(6);
            newTicketBody.setFlag(7);
            newTicketBody.setStartTime(startTime);
        }
        long till = 0L;
        till = request.getTill().getTime() == 0L ? Long.MAX_VALUE : request.getTill().getTime();
        long endTime = Math.min(till, startTime.getTime() + config.getMaximumTicketLifetime());
        KerberosTime kerberosEndTime = new KerberosTime(endTime);
        newTicketBody.setEndTime(kerberosEndTime);
        if (kerberosEndTime.lessThan(startTime)) {
            throw new KerberosException(ErrorType.KDC_ERR_NEVER_VALID);
        }
        long ticketLifeTime = Math.abs(startTime.getTime() - kerberosEndTime.getTime());
        if (ticketLifeTime < config.getAllowableClockSkew()) {
            throw new KerberosException(ErrorType.KDC_ERR_NEVER_VALID);
        }
        KerberosTime tempRtime = request.getRtime();
        if (request.getOption(27) && request.getTill().greaterThan(kerberosEndTime)) {
            if (!config.isRenewableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            request.setOption(8);
            tempRtime = request.getTill();
        }
        if (request.getOption(8)) {
            if (!config.isRenewableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag(8);
            if (tempRtime == null || tempRtime.isZero()) {
                tempRtime = KerberosTime.INFINITY;
            }
            long renewTill = Math.min(tempRtime.getTime(), startTime.getTime() + config.getMaximumRenewableLifetime());
            newTicketBody.setRenewTill(new KerberosTime(renewTill));
        }
        if (request.getAddresses() != null && request.getAddresses().getAddresses() != null && request.getAddresses().getAddresses().length > 0) {
            newTicketBody.setClientAddresses(request.getAddresses());
        } else if (!config.isEmptyAddressesAllowed()) {
            throw new KerberosException(ErrorType.KDC_ERR_POLICY);
        }
        EncTicketPart ticketPart = newTicketBody.getEncTicketPart();
        EncryptedData encryptedData = cipherTextHandler.seal(serverKey, (Encodable)ticketPart, KeyUsage.NUMBER2);
        Ticket newTicket = new Ticket(ticketPrincipal, encryptedData);
        newTicket.setEncTicketPart(ticketPart);
        if (log.isDebugEnabled()) {
            log.debug("Ticket will be issued for access to {}.", (Object)serverPrincipal.toString());
        }
        authContext.setTicket(newTicket);
        next.execute(session, message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

