/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.authentication;

import java.net.InetAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorContext
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(MonitorContext.class);
    private String serviceName;
    private String contextKey = "context";

    public MonitorContext(String serviceName) {
        this.serviceName = serviceName;
    }

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        if (log.isDebugEnabled()) {
            try {
                AuthenticationContext authContext = (AuthenticationContext)session.getAttribute(this.getContextKey());
                long clockSkew = authContext.getConfig().getAllowableClockSkew();
                InetAddress clientAddress = authContext.getClientAddress();
                StringBuffer sb = new StringBuffer();
                sb.append("Monitoring " + this.serviceName + " context:");
                sb.append("\n\tclockSkew              " + clockSkew);
                sb.append("\n\tclientAddress          " + clientAddress);
                KerberosPrincipal clientPrincipal = authContext.getClientEntry().getPrincipal();
                PrincipalStoreEntry clientEntry = authContext.getClientEntry();
                sb.append("\n\tprincipal              " + clientPrincipal);
                sb.append("\n\tcn                     " + clientEntry.getCommonName());
                sb.append("\n\trealm                  " + clientEntry.getRealmName());
                sb.append("\n\tprincipal              " + clientEntry.getPrincipal());
                sb.append("\n\tSAM type               " + clientEntry.getSamType());
                KerberosPrincipal serverPrincipal = authContext.getRequest().getServerPrincipal();
                PrincipalStoreEntry serverEntry = authContext.getServerEntry();
                sb.append("\n\tprincipal              " + serverPrincipal);
                sb.append("\n\tcn                     " + serverEntry.getCommonName());
                sb.append("\n\trealm                  " + serverEntry.getRealmName());
                sb.append("\n\tprincipal              " + serverEntry.getPrincipal());
                sb.append("\n\tSAM type               " + serverEntry.getSamType());
                EncryptionType encryptionType = authContext.getEncryptionType();
                int clientKeyVersion = ((EncryptionKey)clientEntry.getKeyMap().get(encryptionType)).getKeyVersion();
                int serverKeyVersion = ((EncryptionKey)serverEntry.getKeyMap().get(encryptionType)).getKeyVersion();
                sb.append("\n\tRequest key type       " + encryptionType);
                sb.append("\n\tClient key version     " + clientKeyVersion);
                sb.append("\n\tServer key version     " + serverKeyVersion);
                log.debug(sb.toString());
            }
            catch (Exception e) {
                log.error("Error in context monitor", (Throwable)e);
            }
        }
        next.execute(session, message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

