/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.authentication;

import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.messages.AuthenticationReply;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class SealReply
implements IoHandlerCommand {
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        AuthenticationContext authContext = (AuthenticationContext)session.getAttribute(this.getContextKey());
        AuthenticationReply reply = (AuthenticationReply)authContext.getReply();
        EncryptionKey clientKey = authContext.getClientKey();
        CipherTextHandler cipherTextHandler = authContext.getCipherTextHandler();
        EncryptedData encryptedData = cipherTextHandler.seal(clientKey, (Encodable)reply, KeyUsage.NUMBER3);
        reply.setEncPart(encryptedData);
        next.execute(session, message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

