/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.preauthentication;

import javax.security.auth.kerberos.KerberosKey;
import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.authentication.AuthenticationContext;
import org.apache.directory.server.kerberos.kdc.preauthentication.VerifierBase;
import org.apache.directory.server.kerberos.sam.SamException;
import org.apache.directory.server.kerberos.sam.SamSubsystem;
import org.apache.directory.server.kerberos.sam.TimestampChecker;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.PreAuthenticationData;
import org.apache.directory.server.kerberos.shared.messages.value.PreAuthenticationDataType;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifySam
extends VerifierBase {
    private static final Logger log = LoggerFactory.getLogger(VerifySam.class);

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        log.debug("Verifying using SAM subsystem.");
        AuthenticationContext authContext = (AuthenticationContext)session.getAttribute(this.getContextKey());
        KdcRequest request = authContext.getRequest();
        KdcConfiguration config = authContext.getConfig();
        PrincipalStoreEntry clientEntry = authContext.getClientEntry();
        String clientName = clientEntry.getPrincipal().getName();
        EncryptionKey clientKey = null;
        if (clientEntry.getSamType() != null) {
            PreAuthenticationData[] preAuthData;
            if (log.isDebugEnabled()) {
                log.debug("Entry for client principal {} has a valid SAM type.  Invoking SAM subsystem for pre-authentication.", (Object)clientName);
            }
            if ((preAuthData = request.getPreAuthData()) == null || preAuthData.length == 0) {
                throw new KerberosException(ErrorType.KDC_ERR_PREAUTH_REQUIRED, this.preparePreAuthenticationError(config.getEncryptionTypes()));
            }
            try {
                for (int ii = 0; ii < preAuthData.length; ++ii) {
                    if (!preAuthData[ii].getDataType().equals(PreAuthenticationDataType.PA_ENC_TIMESTAMP)) continue;
                    KerberosKey samKey = SamSubsystem.getInstance().verify(clientEntry, preAuthData[ii].getDataValue());
                    clientKey = new EncryptionKey(EncryptionType.getTypeByOrdinal((int)samKey.getKeyType()), samKey.getEncoded());
                }
            }
            catch (SamException se) {
                throw new KerberosException(ErrorType.KRB_ERR_GENERIC, (Throwable)se);
            }
            authContext.setClientKey(clientKey);
            authContext.setPreAuthenticated(true);
            if (log.isDebugEnabled()) {
                log.debug("Pre-authentication using SAM subsystem successful for {}.", (Object)clientName);
            }
        }
        next.execute(session, message);
    }

    static {
        log.debug("Initializing SAM subsystem.");
        SamSubsystem.getInstance().setIntegrityChecker(new TimestampChecker());
    }
}

