/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.KerberosMessage;
import org.apache.directory.server.kerberos.shared.messages.TicketGrantReply;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.LastRequest;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class BuildReply
implements IoHandlerCommand {
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        TicketGrantingContext tgsContext = (TicketGrantingContext)session.getAttribute(this.getContextKey());
        KdcRequest request = tgsContext.getRequest();
        Ticket tgt = tgsContext.getTgt();
        Ticket newTicket = tgsContext.getNewTicket();
        TicketGrantReply reply = new TicketGrantReply();
        reply.setClientPrincipal(tgt.getClientPrincipal());
        reply.setTicket(newTicket);
        reply.setKey(newTicket.getSessionKey());
        reply.setNonce(request.getNonce());
        reply.setLastRequest(new LastRequest());
        reply.setFlags(newTicket.getFlags());
        reply.setClientAddresses(newTicket.getClientAddresses());
        reply.setAuthTime(newTicket.getAuthTime());
        reply.setStartTime(newTicket.getStartTime());
        reply.setEndTime(newTicket.getEndTime());
        reply.setServerPrincipal(newTicket.getServerPrincipal());
        if (newTicket.getFlag(8)) {
            reply.setRenewTill(newTicket.getRenewTill());
        }
        tgsContext.setReply((KerberosMessage)reply);
        next.execute(session, message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

