/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.replay.InMemoryReplayCache;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class ConfigureTicketGrantingChain
implements IoHandlerCommand {
    private static final InMemoryReplayCache replayCache = new InMemoryReplayCache();
    private static final CipherTextHandler cipherTextHandler = new CipherTextHandler();
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        TicketGrantingContext tgsContext = (TicketGrantingContext)session.getAttribute(this.getContextKey());
        KdcConfiguration config = tgsContext.getConfig();
        long clockSkew = config.getAllowableClockSkew();
        replayCache.setClockSkew(clockSkew);
        tgsContext.setReplayCache((ReplayCache)replayCache);
        tgsContext.setCipherTextHandler(cipherTextHandler);
        if (tgsContext.getRequest().getProtocolVersionNumber() != 5) {
            throw new KerberosException(ErrorType.KDC_ERR_BAD_PVNO);
        }
        next.execute(session, message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

